/*
 * @author lsy
 * @date   2020/7/4
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/page/levelOne/LevelOneListModel.dart';
import 'package:gm_flutter/ClueModel/server/entity/LevelOneFeedList.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/eventbus/SimpleEventBus.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

import 'LevelOneItem.dart';

class LevelOneList extends StatefulWidget {
  double topHeight;
  int planId;
  String tabName;

  LevelOneList(this.planId, this.tabName, this.topHeight);

  @override
  State<StatefulWidget> createState() => LevelOneListState();
}

class LevelOneListState extends State<LevelOneList>
    with AutomaticKeepAliveClientMixin{
  LevelOneListModel _model = LevelOneListModel();
  RefreshController refreshController = RefreshController();

  Function(String str) refresh;

  @override
  void initState() {
    super.initState();
    _model.plan_id = widget.planId;
    _model.tab_type = widget.tabName;
    _model.refreshView(true);
    refresh = (str) {
      _model.stateLive.notifyView(LOADING);
      _model.refreshView(true);
    };
    SimpleEventBus.instance().resignEvent("LevelOneList", refresh);
  }

  @override
  void dispose() {
    refreshController.dispose();
    _model.dispose();
    SimpleEventBus.instance().unResignEvent("LevelOneList", refresh);
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    super.build(context);
    return baseStateView(MediaQuery.of(context).size.width,
        MediaQuery.of(context).size.height, _model.stateLive, pages(), () {
      _model.refreshView(true);
    }, paddingTop: widget.topHeight);
  }

  Widget pages() {
    return baseRefreshView(refreshController, () {}, null, null,
        customScrollView: CustomScrollView(
//          physics: NeverScrollableScrollPhysics(),
          physics: ClampingScrollPhysics(),
//          shrinkWrap: true,
          slivers: <Widget>[
//            SliverOverlapInjector(
//              handle: NestedScrollView.sliverOverlapAbsorberHandleFor(context),
//            ),
            StreamBuilder<List<Cards>>(
              stream: _model.cardsLive.stream,
              initialData: _model.cardsLive.data ?? [],
              builder: (c, data) {
                if (data.data.isEmpty && _model.page > 1) {
                  refreshController.loadNoData();
                } else {
                  refreshController.loadComplete();
                }
                return SliverList(
                  delegate: SliverChildBuilderDelegate(
                    (BuildContext context, int index) {
                      if(index==_model.data.length){
                        return Container(
                          height: 40,
                          color: Color(0xffF7F6FA),
                        );
                      }
                      return LevelOneItem(_model.data[index]
                      ,lowPrice: (){
                        },);
                    },
                    childCount: _model.data.length+1,
                  ),
                );
              },
            ),
            StreamBuilder<List<Cards>>(
              stream: _model.cardsLive.stream,
              initialData: _model.data ?? [],
              builder: (c, data) {
                double totalHeight = 0;
                _model.data.forEach((element) {
                  totalHeight += LevelOneItem.getCardTypeHeight(element);
                });
                double height = MediaQuery.of(context).size.height -
                    40 -
                    widget.topHeight -
                    totalHeight;
                return SliverToBoxAdapter(
                  child: Container(
                    height: height < 0 ? 0 : height,
                  ),
                );
              },
            ),
          ],
        ), onLoading: () {
      _model.loadMore();
    }, pullDown: false, pullUp: true);
  }

  @override
  bool get wantKeepAlive => true;
}
