/*
 * @author lsy
 * @date   2020/5/14
 **/
import 'dart:io';

import 'package:dio/dio.dart';
import 'package:gm_flutter/commonModel/cache/CacheManager.dart';

import '../App.dart';
import 'DioUtil.dart';

class DioInterceptorManager {
  static DioInterceptorManager _interceptorManager;

  DioInterceptorManager._() {}

  static DioInterceptorManager getInstance() {
    if (_interceptorManager == null) {
      _interceptorManager = new DioInterceptorManager._();
    }
    return _interceptorManager;
  }

  InterceptorsWrapper getIntercept() {
    return new InterceptorsWrapper(onRequest: (opt) {
      if (opt.headers == null) {
        opt.headers = Map();
      }
      if (CacheManager.getInstance().get(MEMORY_CACHE).get(COOKIE) != null) {
        opt.headers[HttpHeaders.cookieHeader] =
            "${CacheManager.getInstance().get(MEMORY_CACHE).get(COOKIE)}";
      }
      if (opt.queryParameters == null) {
        opt.queryParameters = Map<String, dynamic>();
      }
      if (CacheManager.getInstance().get(MEMORY_CACHE).get(APP_NAME) != null) {
        opt.queryParameters[APP_NAME] =
            "${CacheManager.getInstance().get(MEMORY_CACHE).get(APP_NAME)}";
      }
      if (CacheManager.getInstance().get(MEMORY_CACHE).get(VERSION) != null) {
        opt.queryParameters[VERSION] =
            "${CacheManager.getInstance().get(MEMORY_CACHE).get(VERSION)}";
      }
      if (CacheManager.getInstance().get(MEMORY_CACHE).get(PLATFORM) != null) {
        opt.queryParameters[PLATFORM] =
            "${CacheManager.getInstance().get(MEMORY_CACHE).get(PLATFORM)}";
      }
      if (CacheManager.getInstance().get(MEMORY_CACHE).get(DEVICE_ID) != null) {
        opt.queryParameters[DEVICE_ID] =
            "${CacheManager.getInstance().get(MEMORY_CACHE).get(DEVICE_ID)}";
      }
      if (CacheManager.getInstance().get(MEMORY_CACHE).get(OS_VERSION) !=
          null) {
        opt.queryParameters[OS_VERSION] =
            "${CacheManager.getInstance().get(MEMORY_CACHE).get(OS_VERSION)}";
      }
      if (CacheManager.getInstance().get(MEMORY_CACHE).get(MODEL) != null) {
        opt.queryParameters[MODEL] =
            "${CacheManager.getInstance().get(MEMORY_CACHE).get(MODEL)}";
      }
      if (CacheManager.getInstance().get(MEMORY_CACHE).get(SCREEN) != null) {
        opt.queryParameters[SCREEN] =
            "${CacheManager.getInstance().get(MEMORY_CACHE).get(SCREEN)}";
      }
      if (CacheManager.getInstance().get(MEMORY_CACHE).get(LAT) != null) {
        opt.queryParameters[LAT] =
            "${CacheManager.getInstance().get(MEMORY_CACHE).get(LAT)}";
      }
      if (CacheManager.getInstance().get(MEMORY_CACHE).get(LNG) != null) {
        opt.queryParameters[LNG] =
            "${CacheManager.getInstance().get(MEMORY_CACHE).get(LNG)}";
      }
      if (CacheManager.getInstance().get(MEMORY_CACHE).get(CHANNEL) != null) {
        opt.queryParameters[CHANNEL] =
            "${CacheManager.getInstance().get(MEMORY_CACHE).get(CHANNEL)}";
      }
      if (CacheManager.getInstance().get(MEMORY_CACHE).get(MANUFACTURER) !=
          null) {
        opt.queryParameters[MANUFACTURER] =
            "${CacheManager.getInstance().get(MEMORY_CACHE).get(MANUFACTURER)}";
      }
      if (CacheManager.getInstance().get(MEMORY_CACHE).get(UUID) != null) {
        opt.queryParameters[UUID] =
            "${CacheManager.getInstance().get(MEMORY_CACHE).get(UUID)}";
      }
      if (Platform.isAndroid) {
        if (CacheManager.getInstance()
                .get(MEMORY_CACHE)
                .get(ANDROID_DEVICE_ID) !=
            null) {
          opt.queryParameters[ANDROID_DEVICE_ID] =
              "${CacheManager.getInstance().get(MEMORY_CACHE).get(ANDROID_DEVICE_ID)}";
        }
      } else {
        if (CacheManager.getInstance().get(MEMORY_CACHE).get(RELEASE) != null) {
          opt.queryParameters[RELEASE] =
              "${CacheManager.getInstance().get(MEMORY_CACHE).get(RELEASE)}";
        }
        if (CacheManager.getInstance().get(MEMORY_CACHE).get(IDFA) != null) {
          opt.queryParameters[IDFA] =
              "${CacheManager.getInstance().get(MEMORY_CACHE).get(IDFA)}";
        }
        if (CacheManager.getInstance().get(MEMORY_CACHE).get(IDFV) != null) {
          opt.queryParameters[IDFV] =
              "${CacheManager.getInstance().get(MEMORY_CACHE).get(IDFV)}";
        }
        if (CacheManager.getInstance().get(MEMORY_CACHE).get(IS_WIFI) != null) {
          opt.queryParameters[IS_WIFI] =
              "${CacheManager.getInstance().get(MEMORY_CACHE).get(IS_WIFI)}";
        }
        if (CacheManager.getInstance().get(MEMORY_CACHE).get(HARDWARE_MODEL) !=
            null) {
          opt.queryParameters[HARDWARE_MODEL] =
              "${CacheManager.getInstance().get(MEMORY_CACHE).get(HARDWARE_MODEL)}";
        }
        if (CacheManager.getInstance().get(MEMORY_CACHE).get(CURRENT_CITY_ID) !=
            null) {
          opt.queryParameters[CURRENT_CITY_ID] =
              "${CacheManager.getInstance().get(MEMORY_CACHE).get(CURRENT_CITY_ID)}";
        }
      }

      print("请求之前  onRequest${opt.uri}${opt.queryParameters}${opt.headers}");
    }, onResponse: (response) {
      print("响应之前  ");
    }, onError: (e) {
      print("网络错误  $e message ${e.message}");
    });
  }

  String formatError(DioError e) {
    String reason = "";
    if (e.type == DioErrorType.CONNECT_TIMEOUT) {
      // It occurs when url is opened timeout.
      reason = "连接超时 ${e.message}";
    } else if (e.type == DioErrorType.SEND_TIMEOUT) {
      // It occurs when url is sent timeout.
      reason = "请求超时 ${e.message}";
    } else if (e.type == DioErrorType.RECEIVE_TIMEOUT) {
      //It occurs when receiving timeout
      reason = "响应超时 ${e.message}";
    } else if (e.type == DioErrorType.RESPONSE) {
      // When the server response, but with a incorrect status, such as 404, 503...
      reason = "出现异常 ${e.message}";
    } else if (e.type == DioErrorType.CANCEL) {
      // When the request is cancelled, dio will throw a error with this type.
      reason = "请求取消 ${e.message}";
    } else {
      //DEFAULT Default error type, Some other Error. In this case, you can read the DioError.error if it is not null.
      reason = "未知错误 ${e.message}";
    }
    return reason;
  }
}
