/*
 * @author lsy
 * @date   2019-10-18
 **/

import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/view/iOSLoading.dart';

import 'base/DialogRouter.dart';

Future popLoadingDialogText(BuildContext context, bool canceledOnTouchOutside,
    String text, ChangeNotifier dismiss) {
  return Navigator.push(context,
      DialogRouter(LoadingDialog(canceledOnTouchOutside, text, dismiss)));
}

class LoadingDialog extends StatefulWidget {
  LoadingDialog(this.canceledOnTouchOutside, this.text, this.dismiss) : super();

  ///点击背景是否能够退出
  final bool canceledOnTouchOutside;
  final String text;
  final ChangeNotifier dismiss;

  @override
  State<StatefulWidget> createState() => LoadingDialogState();
}

class LoadingDialogState extends State<LoadingDialog> {
  @override
  void initState() {
    super.initState();
    widget.dismiss.addListener(() {
      if (widget.dismiss != null) {
        Navigator.pop(context);
        widget.dismiss.dispose();
      }
    });
  }

  @override
  Widget build(BuildContext context) {
    return Center(
      child: new Material(

          ///背景透明
          color: Colors.transparent,

          ///保证控件居中效果
          child: Stack(
            children: <Widget>[
              GestureDetector(
                ///点击事件
                onTap: () {
                  if (widget.canceledOnTouchOutside) {
                    Navigator.pop(context);
                  }
                },
              ),
              _dialog()
            ],
          )),
    );
  }

  Widget _dialog() {
    return new Center(
      ///弹框大小
      child: new Container(
        width: 120.0,
        height: 120.0,
        child: new Container(
          ///弹框背景和圆角
          decoration: ShapeDecoration(
            color: Colors.black,
            shape: RoundedRectangleBorder(
              borderRadius: BorderRadius.all(
                Radius.circular(8.0),
              ),
            ),
          ),
          child: new Column(
            mainAxisAlignment: MainAxisAlignment.center,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: <Widget>[
              new MyCupertinoActivityIndicator(
                backColor: Colors.white,
              ),
              new Padding(
                padding: const EdgeInsets.only(
                  top: 20.0,
                ),
                child: new Text(
                  widget.text,
                  style: new TextStyle(fontSize: 16.0, color: Colors.white),
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
