/*
 * @author lsy
 * @date   2020/6/29
 **/
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/LevelOneFeedList.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanOverviewBean.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:gm_flutter/commonModel/util/PrintUtil.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';

import '../../../commonModel/bean/Pair.dart';

class LevelTwoModel extends BaseModel {
  LiveData<Pair<int, String>> nameLive = LiveData();
  LiveData<Pair<int, String>> imageUrlLive = LiveData();
  LiveData<Pair<int, List<OverviewAttrsEntity>>> overviewAttrsLive = LiveData();
  LiveData<Pair<int, List<ExplanationAttrsEntity>>> explanationAttrsLive =
      LiveData();
  LiveData<Pair<int, List<Tabs>>> tabsLive = LiveData();

  LiveData<int> stateLive = LiveData();
  LiveData<Pair<int, List<Cards>>> cardsLive = LiveData();
  RxDispose rxDispose = RxDispose();

  getPlanOverview(int plan_id) {
    ClueApiImpl.getInstance()
        .getPlanOverviewBean(DioUtil.getInstance().getDio(), plan_id)
        .listen((event) {
          if (event.error == 0) {
            stateLive.notifyView(ENDLOADING);
            nameLive.notifyView(Pair(ENDLOADING, event.data.name));
            imageUrlLive
                .notifyView(Pair(ENDLOADING, event.data.banner.imageUrl));
            overviewAttrsLive
                .notifyView(Pair(ENDLOADING, event.data.overviewAttrs));
            explanationAttrsLive
                .notifyView(Pair(ENDLOADING, event.data.explanationAttrs));
            tabsLive.notifyView(Pair(ENDLOADING, event.data.tabs));
          } else {
            NativeToast.showNativeToast(event.message);
            commonError();
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          commonError();
          PrintUtil.printBug(err);
        });
  }

  commonError() {
    stateLive.notifyView(FAIL);
    nameLive.notifyView(Pair(FAIL, null));
    imageUrlLive.notifyView(Pair(FAIL, null));
    overviewAttrsLive.notifyView(Pair(FAIL, null));
    explanationAttrsLive.notifyView(Pair(FAIL, null));
    tabsLive.notifyView(Pair(FAIL, null));
  }

  @override
  void dispose() {
    nameLive.dispost();
    imageUrlLive.dispost();
    overviewAttrsLive.dispost();
    explanationAttrsLive.dispost();
    tabsLive.dispost();
    stateLive.dispost();
    rxDispose.dispose();
  }

  void loadMore() {}
}
