/*
 * @author lsy
 * @date   2020/7/3
 **/
class PlanBarBean {
  int error;
  String message;
  Null extra;
  Null errorExtra;
  UserType userType;
  Data data;

  PlanBarBean({this.error, this.message, this.extra, this.errorExtra, this.userType, this.data});

  PlanBarBean.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    errorExtra = json['error_extra'];
    userType = json['user_type'] != null ? new UserType.fromJson(json['user_type']) : null;
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    data['error_extra'] = this.errorExtra;
    if (this.userType != null) {
      data['user_type'] = this.userType.toJson();
    }
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    return data;
  }
}

class UserType {


  UserType();

UserType.fromJson(Map<String, dynamic> json) {
}

Map<String, dynamic> toJson() {
  final Map<String, dynamic> data = new Map<String, dynamic>();
  return data;
}
}

class Data {
  String bannerImage;
  List<Tabs> tabs;

  Data({this.bannerImage, this.tabs});

  Data.fromJson(Map<String, dynamic> json) {
    bannerImage = json['banner_image'];
    if (json['tabs'] != null) {
      tabs = new List<Tabs>();
      json['tabs'].forEach((v) { tabs.add(new Tabs.fromJson(v)); });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['banner_image'] = this.bannerImage;
    if (this.tabs != null) {
      data['tabs'] = this.tabs.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Tabs {
  bool selected;
  int id;
  String name;

  Tabs({this.selected, this.id, this.name});

  Tabs.fromJson(Map<String, dynamic> json) {
    selected = json['selected'];
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['selected'] = this.selected;
    data['id'] = this.id;
    data['name'] = this.name;
    return data;
  }
}

