import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/picker/base/BaseBottomPicker.dart';

class MechanismBox implements IBottomPicker {
  VoidCallback dismissCall;
  TextEditingController textController = TextEditingController();
  @override
  initState(dismissCall, BuildContext context) {
    this.dismissCall = dismissCall;
  }

  Widget build(BuildContext context) {
    MediaQueryData mq = MediaQuery.of(context);
    double keyHeight = MediaQuery.of(context).viewInsets.bottom;
    return ClipRRect(
      borderRadius: BorderRadius.only(
          topLeft: Radius.circular(10.0), topRight: Radius.circular(10.0)),
      child: Container(
          width: mq.size.width,
          height: mq.size.height - 140,
          color: Colors.white,
          child: Stack(
            children: <Widget>[
              Container(
                margin: EdgeInsets.only(left: 20, right: 20),
                width: mq.size.width,
                decoration: BoxDecoration(
                    border: Border(
                        bottom:
                            BorderSide(width: 1, color: Color(0xffE5E5E5)))),
                height: 50,
                child: Stack(
                  alignment: Alignment.center,
                  children: <Widget>[
                    Container(
                      child: Text(
                        '请选择要咨询的机构',
                        style: TextStyle(
                            color: Color(0xff282828),
                            fontSize: 17,
                            fontWeight: FontWeight.bold),
                      ),
                    ),
                    Positioned(
                        right: 0,
                        top: 16.0,
                        child: GestureDetector(
                          onTap: () {
                            dismissCall();
                          },
                          child: Container(
                            width: 14,
                            height: 14,
                            child: Image.asset("assets/close-btn.png"),
                          ),
                        ))
                  ],
                ),
              ),
              Container(
                  height: mq.size.height - 140 - 96 - 50,
                  width: mq.size.width,
                  margin: EdgeInsets.only(top: 50),
                  padding: EdgeInsets.only(left: 20, right: 20),
                  child: ListView.separated(
                    itemCount: 100,
                    itemBuilder: (BuildContext context, int index) {
                      return ListTile(title: Text("$index"));
                    },
                    separatorBuilder: (BuildContext context, int index) {
                      return Divider(color: Color(0xffE5E5E5));
                    },
                  )),
              Positioned(
                  bottom: keyHeight == 0 ? 0 : keyHeight,
                  left: 0,
                  width: double.maxFinite,
                  height: 96,
                  child: Container(
                      height: 96,
                      color: Color(0xffF9F8FB),
                      child: Column(
                        children: <Widget>[
                          Container(
                            height: 25,
                            color: Colors.black,
                            width: double.maxFinite,
                            margin: EdgeInsets.only(top: 12),
                            child: ListView(
                              scrollDirection: Axis.horizontal, //横向滚动
                              children: <Widget>[
                                Container(
                                    margin: EdgeInsets.only(left: 15, right: 8),
                                    height: 25,
                                    child: Text(
                                      '我想',
                                      style: TextStyle(
                                          height: 2,
                                          color: Color(0xff666666),
                                          fontSize: 12),
                                    )),
                                Container(
                                  height: 25,
                                  margin: EdgeInsets.only(right: 12),
                                  padding: EdgeInsets.only(left: 8, right: 8),
                                  decoration: BoxDecoration(
                                      border: Border.all(
                                          color: Color(0xffE5E5E5), width: 0.5),
                                      color: Color(0xffffffff),
                                      borderRadius: BorderRadius.circular(20)),
                                  child: Text(
                                    '有优惠活动吗？',
                                    style: TextStyle(
                                        fontSize: 12,
                                        color: Color(0xff666666),
                                        height: 1.8),
                                  ),
                                ),
                                Container(
                                    height: 25,
                                    margin: EdgeInsets.only(right: 12),
                                    padding: EdgeInsets.only(left: 8, right: 8),
                                    decoration: BoxDecoration(
                                        border: Border.all(
                                            color: Color(0xffE5E5E5),
                                            width: 0.5),
                                        color: Color(0xffffffff),
                                        borderRadius:
                                            BorderRadius.circular(20)),
                                    child: Text(
                                      '111有优惠活动吗？',
                                      style: TextStyle(
                                          fontSize: 12,
                                          color: Color(0xff666666),
                                          height: 1.8),
                                    )),
                                Container(
                                    height: 25,
                                    margin: EdgeInsets.only(right: 12),
                                    padding: EdgeInsets.only(left: 8, right: 8),
                                    decoration: BoxDecoration(
                                        border: Border.all(
                                            color: Color(0xffE5E5E5),
                                            width: 0.5),
                                        color: Color(0xffffffff),
                                        borderRadius:
                                            BorderRadius.circular(20)),
                                    child: Text(
                                      '111有优惠活动吗？',
                                      style: TextStyle(
                                          fontSize: 12,
                                          color: Color(0xff666666),
                                          height: 1.8),
                                    )),
                                Container(
                                    height: 25,
                                    margin: EdgeInsets.only(right: 12),
                                    padding: EdgeInsets.only(left: 8, right: 8),
                                    decoration: BoxDecoration(
                                        border: Border.all(
                                            color: Color(0xffE5E5E5),
                                            width: 0.5),
                                        color: Color(0xffffffff),
                                        borderRadius:
                                            BorderRadius.circular(20)),
                                    child: Text(
                                      '111有优惠活动吗？',
                                      style: TextStyle(
                                          fontSize: 12,
                                          color: Color(0xff666666),
                                          height: 1.8),
                                    ))
                              ],
                            ),
                          ),
                          Container(
                            height: 35,
                            margin:
                                EdgeInsets.only(top: 12, left: 15, right: 15),
                            decoration: BoxDecoration(
                                border: Border.all(
                                    color: Color(0xffE5E5E5), width: 0.5),
                                color: Color(0xffffffff),
                                borderRadius: BorderRadius.circular(35)),
                            child: TextField(
                                controller: textController,
                                keyboardType: TextInputType.text,
                                textInputAction: TextInputAction.send,
                                onSubmitted: (txt) {},
                                decoration: InputDecoration(
                                    contentPadding: EdgeInsets.all(16.0),
                                    labelText: '文案文案文案不知道文案是啥',
                                    border: InputBorder.none)),
                          )
                        ],
                      )))
            ],
          )),
    );
  }

  @override
  void dispose() {
    textController.dispose();
  }
}
