/*
 * @Author: zx 
 * @Date: 2020-07-03 20:56:15 
 * @Last Modified by: zx
 * @Last Modified time: 2020-07-03 20:57:44
 */

class DiscussLowPriceModelBean {
  int error;
  String message;
  Null extra;
  Null errorExtra;
  UserType userType;
  Data data;

  DiscussLowPriceModelBean(
      {this.error,
      this.message,
      this.extra,
      this.errorExtra,
      this.userType,
      this.data});

  DiscussLowPriceModelBean.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    errorExtra = json['error_extra'];
    userType = json['user_type'] != null
        ? new UserType.fromJson(json['user_type'])
        : null;
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    data['error_extra'] = this.errorExtra;
    if (this.userType != null) {
      data['user_type'] = this.userType.toJson();
    }
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    return data;
  }
}

class UserType {
  UserType();

  UserType.fromJson(Map<String, dynamic> json) {}

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    return data;
  }
}

class Data {
  int leadPhoneRequestId;
  int authorizeType;
  String icon;
  String tip;
  String title;
  String authorizePhone;

  Data(
      {this.leadPhoneRequestId,
      this.authorizeType,
      this.icon,
      this.tip,
      this.title,
      this.authorizePhone});

  Data.fromJson(Map<String, dynamic> json) {
    leadPhoneRequestId = json['lead_phone_request_id'];
    authorizeType = json['authorize_type'];
    icon = json['icon'];
    tip = json['tip'];
    title = json['title'];
    authorizePhone = json['authorize_phone'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['lead_phone_request_id'] = this.leadPhoneRequestId;
    data['authorize_type'] = this.authorizeType;
    data['icon'] = this.icon;
    data['tip'] = this.tip;
    data['title'] = this.title;
    data['authorize_phone'] = this.authorizePhone;
    return data;
  }
}
