/*
 * @author lsy
 * @date   2020/7/2
 **/
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/page/plan/PlanItem.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanFeedBean.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

import 'TopListModel.dart';

class TopList extends StatefulWidget {
  final int id;
  double topHeight;

  TopList(this.id, this.topHeight);

  @override
  State<StatefulWidget> createState() => TopListState();
}

class TopListState extends State<TopList> {
  RefreshController refreshController = RefreshController();
  TopListModel _model = TopListModel();

  @override
  void initState() {
    super.initState();
    _model.getData(true);
    print("${this}  INIT");
  }

  @override
  void dispose() {
    refreshController.dispose();
    _model.dispose();
    print("${this}  QUIT");
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return baseStateView(MediaQuery.of(context).size.width,
        MediaQuery.of(context).size.height, _model.stateLive, home(), () {
      _model.getData(true);
    });
  }

  Widget home() {
    return baseRefreshView(refreshController, () {}, null, null,
        customScrollView: CustomScrollView(
//          physics: NeverScrollableScrollPhysics(),
          physics: ClampingScrollPhysics(),
//          shrinkWrap: true,
          slivers: <Widget>[
            SliverOverlapInjector(
              handle: NestedScrollView.sliverOverlapAbsorberHandleFor(context),
            ),
            StreamBuilder<List<Plans>>(
              stream: _model.datasLive.stream,
              initialData: _model.datas ?? [],
              builder: (c, data) {
                print("LLDATA ${data.data}");
                if (data.data.isEmpty && _model.page > 1) {
                  refreshController.loadNoData();
                } else {
                  refreshController.loadComplete();
                }
                return SliverFixedExtentList(
                  itemExtent: 100,
                  delegate: SliverChildBuilderDelegate(
                    (BuildContext context, int index) {
                      return PlanItem(_model.datas[index]);
                    },
                    childCount: _model.datas.length,
                  ),
                );
              },
            ),
            StreamBuilder<List<Plans>>(
              stream: _model.datasLive.stream,
              initialData: _model.datas ?? [],
              builder: (c, data) {
                double height = MediaQuery.of(context).size.height -
                    40 -
                    widget.topHeight -
                    100 * _model.datas.length;
                return SliverToBoxAdapter(
                  child: Container(
                    height: height < 0 ? 0 : height,
                  ),
                );
              },
            ),
          ],
        ), onLoading: () {
      _model.loadMore();
    }, pullDown: false, pullUp: true);
  }
}
