/*
 * @author lsy
 * @date   2020/6/29
 **/
import 'package:flutter/services.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:gm_flutter/commonModel/base/BaseUtil.dart';

class MainManager {
  MethodChannel flutterChannel;
  EventChannel flutterEvent;
  bool isInit = false;

  MainManager._() {}

  static MainManager _mainManager;

  static MainManager getInstance() {
    if (_mainManager == null) {
      _mainManager = MainManager._();
    }
    return _mainManager;
  }

  startInit() {
    if (isInit) {
      return;
    }
    isInit = true;
    print("LSY STATEINIT METHOD AND CHANNEL ");
    flutterChannel = MethodChannel('gm_method_channel');
    flutterEvent = EventChannel('gm_method_event');
    flutterEvent.receiveBroadcastStream().listen((data) {
      print("LSY FLUTTER  EVENT  ${data}");
    });
  }

  void buriedEvent(String name, Map<String, dynamic> map) {
    if (flutterChannel != null) {
      flutterChannel.invokeMethod("buried-${name}", map);
    } else {
      if (isDebug) {
        throw Exception("wrong");
      }
    }
  }
}
