/*
 * @author dx
 * @date 2020-06-29
 **/

import 'dart:math';

import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/picker/base/BaseBottomPicker.dart';
import 'package:gm_flutter/ClueModel/page/levelTwo/LevelTwoModel.dart';
import 'package:gm_flutter/ClueModel/page/mechanismBox/MechanismBoxPage.dart';
import 'package:gm_flutter/ClueModel/server/entity/LevelOneFeedList.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanOverviewBean.dart';
import 'package:gm_flutter/ClueModel/view/FiveStarView.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';
import 'package:gm_flutter/commonModel/base/BaseUtil.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';

import '../../../commonModel/bean/Pair.dart';
import '../../../commonModel/bean/Pair.dart';
import '../../../commonModel/bean/Pair.dart';

class LevelTwoPage extends StatefulWidget {
  @required
  final int plan_id;

  const LevelTwoPage({Key key, this.plan_id}) : super(key: key);

  @override
  _LevelTwoPageState createState() => _LevelTwoPageState();
}

class _LevelTwoPageState extends BaseState<LevelTwoPage>
    with SingleTickerProviderStateMixin {
  LevelTwoModel _model = new LevelTwoModel();
  RefreshController _refreshController = RefreshController();
  PageController pageController = new PageController();
  TabController tabController;

  @override
  void initState() {
    super.initState();
    this.tabController = TabController(length: 2, vsync: this);
    _model.getPlanOverview(this.widget.plan_id);
  }

  @override
  void dispose() {
    _model.dispose();
    pageController.dispose();
    _refreshController.dispose();
    super.dispose();
  }

  @override
  Widget buildItem(BuildContext context) {
    return Scaffold(
        body: StreamBuilder<int>(
      stream: _model.stateLive.stream,
      initialData: _model.stateLive.data ?? LOADING,
      builder: (c, data) {
        print("ddsadsadsadsa");
        print(data);
        if (data.data == FAIL) {
          return loadingItem();
        } else {
          return home();
        }
      },
    ));
  }

  Widget home() {
    return Stack(
      children: <Widget>[
        CustomScrollView(slivers: <Widget>[
          SliverAppBar(
            pinned: true,
            elevation: 0,
            expandedHeight: 0,
            flexibleSpace: FlexibleSpaceBar(title: title((data) {
              return Text(data);
            })),
          ),
          SliverToBoxAdapter(
              child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisSize: MainAxisSize.max,
            children: <Widget>[good(), rect(), explain()],
          )),
          SliverPersistentHeader(
            pinned: true,
            delegate: StickyTabBarDelegate(
              child: baseTabBar(tabController,
                  [baseTabBarItem("医院"), baseTabBarItem("医生")], (index) {},
                  scroll: false),
            ),
          ),
          // SliverFillRemaining(child: pages())
        ]),
        Positioned(left: 0, right: 0, bottom: 0, child: bottomWidget())
      ],
    );
  }

  // 方案名称
  Widget title(Function text) {
    return StreamBuilder<Pair<int, String>>(
      stream: _model.nameLive.stream,
      initialData: _model.nameLive.data ?? Pair(LOADING, null),
      builder: (context, e) {
        if (e.data.first == FAIL) {
          return Text('');
        }
        return text(e.data.second);
      },
    );
  }

  // 方案顶部
  Widget good() {
    return Padding(
      padding: EdgeInsets.only(left: 15.0, right: 15.0, top: 8.0),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisSize: MainAxisSize.max,
        children: <Widget>[
          StreamBuilder<Pair<int, String>>(
              stream: _model.imageUrlLive.stream,
              initialData: _model.imageUrlLive.data ?? null,
              builder: (context, e) {
                if (e.data.first == FAIL) {
                  return Container();
                }
                return ClipRRect(
                    borderRadius: BorderRadius.circular(6),
                    child: Container(
                      decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(17),
                          border:
                              Border.all(color: Color(0xffF9F8FB), width: 1)),
                      child: Image.network(
                        e.data.second,
                        width: 86,
                        height: 86,
                        fit: BoxFit.cover,
                      ),
                    ));
              }),
          Padding(
              padding: EdgeInsets.only(left: 12, top: 5),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                mainAxisSize: MainAxisSize.max,
                children: <Widget>[
                  title((data) {
                    return Text(data,
                        style: TextStyle(
                            color: Color(0xff333333),
                            fontSize: 15,
                            fontWeight: FontWeight.bold));
                  }),
                  Padding(padding: EdgeInsets.only(top: 5)),
                  Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    verticalDirection: VerticalDirection.up,
                    children: <Widget>[
                      Text('指导价：',
                          style: TextStyle(
                              color: Color(0xff999999), fontSize: 12)),
                      Text(
                        '¥2000-5000',
                        style:
                            TextStyle(color: Color(0xffFF5963), fontSize: 12),
                      )
                    ],
                  )
                ],
              )),
        ],
      ),
    );
  }

  // 方案属性
  Widget rect() {
    return Padding(
      padding: EdgeInsets.only(top: 20),
      child: StreamBuilder<Pair<int, List<OverviewAttrsEntity>>>(
        stream: _model.overviewAttrsLive.stream,
        initialData: _model.overviewAttrsLive.data ?? Pair(LOADING, null),
        builder: (c, data) {
          if (data.data.first == FAIL) {
            return Center();
          }
          final overviewAttrs = data.data.second;
          List<Widget> list = List();
          for (int i = 0; i < overviewAttrs.length; i += 2) {
            list.add(Expanded(
              child: Container(
                alignment: Alignment.center,
                child: Column(
                  mainAxisSize: MainAxisSize.min,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: <Widget>[
                    baseText(overviewAttrs[i].attrName, 14, Color(0xff282828),
                        bold: true),
                    baseText(overviewAttrs[i].attrValue, 11, Color(0xff999999)),
                  ],
                ),
              ),
            ));
            if (i < overviewAttrs.length - 2) {
              list.add(Container(
                width: 0.5,
                height: 18,
                color: Color(0xFFE5E5E5),
              ));
            }
          }
          return Container(
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(4),
              color: Color(0xffF9F8FB),
            ),
            width: double.maxFinite,
            height: 62,
            margin: EdgeInsets.only(left: 15, right: 15, bottom: 20),
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: list,
            ),
          );
        },
      ),
    );
  }

  // 方案项目说明
  Widget explain() {
    return StreamBuilder<Pair<int, List<ExplanationAttrsEntity>>>(
      stream: _model.explanationAttrsLive.stream,
      initialData: _model.explanationAttrsLive.data ?? Pair(LOADING, null),
      builder: (c, data) {
        List<Widget> list = [];
        List<ExplanationAttrsEntity> explanationAttrs = data.data.second;
        list.add(Container(
          height: 31,
          child: Row(
            children: <Widget>[
              baseText("项目说明", 15, Color(0xff282828)),
              Expanded(
                child: Container(),
              ),
              GestureDetector(
                onTap: () {
                  //TODO
                },
                behavior: HitTestBehavior.opaque,
                child: baseText("了解更多", 12, Color(0xff3FB5AF)),
              )
            ],
          ),
        ));
        for (int i = 0; i < explanationAttrs.length; i += 2) {
          list.add(Container(
            height: 28,
            child: Row(
              children: <Widget>[
                baseText(explanationAttrs[i].attrName, 13, Color(0xff999999)),
                Container(
                  margin: EdgeInsets.only(left: 12),
                  child: baseText(
                      explanationAttrs[i].attrValue, 13, Color(0xff666666)),
                )
              ],
            ),
          ));
        }
        return Container(
          margin: EdgeInsets.only(left: 15, right: 15, bottom: 20),
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: list,
          ),
        );
      },
    );
  }

  // 底部按钮
  Widget bottomWidget() {
    return Container(
      width: double.maxFinite,
      height: 55,
      child: Row(
        mainAxisSize: MainAxisSize.min,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: <Widget>[
          Container(
            margin: EdgeInsets.only(left: 18),
            width: 30,
            child: Column(
              mainAxisSize: MainAxisSize.min,
              children: <Widget>[
                Container(
                  width: 22,
                  height: 22,
                  child: Image.asset("assets/vs_black.png"),
                ),
                Container(
                  margin: EdgeInsets.only(top: 3),
                  child: baseText("去比较", 10, Color(0xff282828)),
                )
              ],
            ),
          ),
          GestureDetector(
              behavior: HitTestBehavior.opaque,
              onTap: () {
                BaseBottomPicker()
                  ..setPicker(MechanismBox(12))
                  ..show(context);
              },
              child: Container(
                margin: EdgeInsets.only(left: 15),
                width: 135,
                height: 40,
                decoration: BoxDecoration(
                    color: Color(0xff51CDC7),
                    borderRadius: BorderRadius.circular(20)),
                alignment: Alignment.center,
                child: baseText("咨询", 14, Colors.white, bold: true),
              )),
          GestureDetector(
              behavior: HitTestBehavior.opaque,
              onTap: () {},
              child: Container(
                margin: EdgeInsets.only(left: 15),
                width: 135,
                height: 40,
                decoration: BoxDecoration(
                    color: Color(0xffF96079),
                    borderRadius: BorderRadius.circular(20)),
                alignment: Alignment.center,
                child: baseText("获取底价", 14, Colors.white, bold: true),
              )),
          Expanded(
            child: Container(),
          )
        ],
      ),
    );
  }

  // 列表页面
  Widget pages() {
    return StreamBuilder<Pair<int, List<Cards>>>(
        stream: _model.cardsLive.stream,
        initialData: _model.cardsLive.data ?? Pair(LOADING, null),
        builder: (c, data) {
          return Container(
              margin: EdgeInsets.only(top: 5),
              width: double.maxFinite,
              child: TabBarView(
                  controller: tabController,
                  children: data.data.second[tabController.index].map((e) {
                    return ListView.builder(
                      physics: NeverScrollableScrollPhysics(),
                      itemBuilder: (c, index) {
                        return Text('$index');
                      },
                      itemCount: 5,
                    );
                  }).toList()));
        });
  }

  // 医生卡片
  Widget DoctorItem(BuildContext context, cards) {
    if (cards.doctor == null && isDebug) {
      throw new Exception();
    }
    return GestureDetector(
      child: Container(
        margin: EdgeInsets.only(left: 15, right: 15),
        height: 127,
        child: Stack(
          children: <Widget>[
            Positioned(
              top: 15,
              child: Container(
                width: 45,
                height: 45,
                child: ClipOval(
                  child: CachedNetworkImage(
                    imageUrl: cards.doctor.portrait,
                  ),
                ),
              ),
            ),
            Positioned(
              left: 57,
              top: 18,
              child: Row(
                mainAxisSize: MainAxisSize.min,
                crossAxisAlignment: CrossAxisAlignment.end,
                children: <Widget>[
                  baseText(cards.doctor.name, 15, Color(0xff333333),
                      bold: true),
                  Container(
                    margin: EdgeInsets.only(left: 4),
                    child: baseText(cards.doctor.name, 15, Color(0xff333333),
                        bold: true),
                  )
                ],
              ),
            ),
            Positioned(
              top: 42,
              right: 0,
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.end,
                mainAxisSize: MainAxisSize.min,
                children: <Widget>[
                  baseText("¥", 12, Color(0xffFF5963)),
                  baseText("${cards.doctor.minPrice}-${cards.doctor.maxPrice}",
                      15, Color(0xffFF5963)),
                ],
              ),
            ),
            Positioned(
              bottom: 15,
              right: 0,
              child: lowPriceWidget(),
            ),
            Positioned(
              bottom: 15,
              right: 187,
              child: askWidget(),
            ),
          ],
        ),
      ),
    );
  }

  // 医院卡片
  Widget HospitalItem(BuildContext context, cards) {
    if (cards.hospital == null && isDebug) {
      throw new Exception();
    }
    return GestureDetector(
        onTap: () {},
        child: Container(
          margin: EdgeInsets.only(left: 15, right: 15),
          height: 149,
          child: Stack(
            children: <Widget>[
              Positioned(
                left: 0,
                top: 15,
                child: Container(
                  width: 45,
                  height: 45,
                  child: ClipOval(
                    child: CachedNetworkImage(
                      imageUrl: cards.hospital.portrait,
                    ),
                  ),
                ),
              ),
              Positioned(
                left: 57,
                top: 17.5,
                child: baseText(cards.hospital.name, 15, Color(0xff333333),
                    bold: true),
              ),
              Positioned(
                top: 42.5,
                right: 0,
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.end,
                  mainAxisSize: MainAxisSize.min,
                  children: <Widget>[
                    baseText("¥", 12, Color(0xffFF5963)),
                    baseText(
                        "${cards.hospital.minPrice}-${cards.hospital.maxPrice}",
                        15,
                        Color(0xffFF5963)),
                  ],
                ),
              ),
              Positioned(
                bottom: 15,
                right: 0,
                child: lowPriceWidget(),
              ),
              Positioned(
                bottom: 15,
                right: 187,
                child: askWidget(),
              ),
              Positioned(
                bottom: 67,
                left: 57,
                child: baseText(cards.hospital.address, 12, Color(0xff666666)),
              ),
              Positioned(
                left: 57,
                top: 43.5,
                child: FiveStarView(cards.hospital.star, 5),
              )
            ],
          ),
        ));
  }

  // 获取低价按钮
  Widget lowPriceWidget() {
    return GestureDetector(
      behavior: HitTestBehavior.opaque,
      child: Container(
        width: 122,
        height: 37,
        decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(18.5),
            color: Color(0xffFFF5F5)),
        alignment: Alignment.center,
        child: baseText("获取底价", 14, Color(0xffFF5963), bold: true),
      ),
    );
  }

  // 咨询按钮
  Widget askWidget() {
    return GestureDetector(
      behavior: HitTestBehavior.opaque,
      child: Container(
        width: 122,
        height: 37,
        decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(18.5),
            color: Color(0xffEEFDFD)),
        alignment: Alignment.center,
        child: baseText("咨询", 14, Color(0xff3FB5AF), bold: true),
      ),
    );
  }
}

class StickyTabBarDelegate extends SliverPersistentHeaderDelegate {
  final Widget child;

  StickyTabBarDelegate({@required this.child});

  @override
  Widget build(
      BuildContext context, double shrinkOffset, bool overlapsContent) {
    return this.child;
  }

  @override
  double get maxExtent => 40;

  @override
  double get minExtent => 40;

  @override
  bool shouldRebuild(SliverPersistentHeaderDelegate oldDelegate) {
    return true;
  }
}
