/*
 * @author lsy
 * @date   2020/7/1
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanBean.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';

class ProjectView extends StatefulWidget {
  final List<Tags> datas;
  final Function(String id) clickCall;

  ProjectView(this.datas, this.clickCall);

  @override
  State<StatefulWidget> createState() => ProjectViewState();
}

class ProjectViewState extends State<ProjectView> {
  int selectIndex = 0;

  @override
  Widget build(BuildContext context) {
    if (widget.datas == null || widget.datas.isEmpty) {
      return Container();
    }
    return Container(
      height: 450,
      color: Colors.white,
      child: Row(
        children: <Widget>[
          Container(
            width: 75,
            child: ListView.builder(
              itemBuilder: (c, index) {
                return Container(
                    height: 50,
                    color:
                        selectIndex == index ? Colors.white : Color(0xffF4F3F8),
                    child: Stack(
                      alignment: AlignmentDirectional.center,
                      children: <Widget>[
                        baseText(
                            widget.datas[index].name,
                            14,
                            selectIndex == index
                                ? Color(0xff4ABAB4)
                                : Color(0xff464646),
                            bold: selectIndex == index ? true : false),
                        Positioned(
                          left: 0,
                          top: 17,
                          child: selectIndex == index
                              ? Container(
                                  width: 3,
                                  height: 16,
                                  decoration: BoxDecoration(
                                      color: Color(0xff4ABAB4),
                                      borderRadius: BorderRadius.circular(1.5)),
                                )
                              : Container(),
                        )
                      ],
                    )).gestureDetector(() {
                  setState(() {
                    selectIndex = index;
                  });
                });
              },
              itemCount: widget.datas.length,
            ),
          ),
          Expanded(
            child: ListView.builder(
              itemBuilder: (c, index) {
                return Container(
                  margin: EdgeInsets.only(left: 20, top: 18, bottom: 18),
                  child: baseText(widget.datas[selectIndex].subTags[index].name,
                      14, Color(0xff464646)),
                ).gestureDetector(() {
                  widget.clickCall(widget.datas[selectIndex].subTags[index].id);
                });
              },
              itemCount: widget.datas[selectIndex].subTags.length,
            ),
          )
        ],
      ),
    );
  }
}
