/*
 * @author lsy
 * @date   2020/7/6
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:flutter_common/commonModel/util/JumpUtil.dart';
import 'package:gm_flutter/MainRouter/manager/MainManager.dart';
import 'package:gm_flutter/main.mark.dart';

class JumpManager {
  static JumpManager _instance;

  JumpManager._() {}

  static JumpManager instance() {
    if (_instance == null) {
      _instance = JumpManager._();
    }
    return _instance;
  }

  void jumpToPage(BuildContext context, String pageName,
      Map<String, dynamic> params, bool nativePage) {
    String pageNameWrap =
        nativePage ? "gm://${pageName}" : "flutter://${pageName}";
    if (!MainManager.getInstance().isInit) {
      JumpUtil.jumpToPageReplaceRight(context, initMap(params)[pageNameWrap]);
    } else {
      FlutterBoost.singleton.open(pageName, urlParams: params);
    }
  }

  Map<String, dynamic> initMap(Map<String, dynamic> params) {
    return {
      "flutter://clueLevelOne":
          RouterCenterImpl().findClueRouter().getLevelOnePage(params),
    };
  }
}
