/*
 * @author zcc
 * @date   2020-07-01
 * 方案对比
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:gm_flutter/ClueModel/page/PlansCompareFeed/PlansCompareFeedModel.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlansCompareFeed.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';
import 'package:gm_flutter/main.mark.dart';

import 'CallBackCompareItem.dart';
import 'PlansCompareFeedItemView.dart';

class PlansCompareFeedPage extends StatefulWidget {
  int _planType;
  int _planId;

  PlansCompareFeedPage(Map<String, dynamic> params) {
    this._planType = params["planType"];
    this._planId = params["planId"];
  }

  @override
  State<StatefulWidget> createState() => _PlansCompareFeedState();
}

class _PlansCompareFeedState extends BaseState<PlansCompareFeedPage>
    implements CallBackCompareItem {
  PlansCompareFeedModel _model;
  Color _compareColor;
  Set<int> _setCompare;

  @override
  void initState() {
    super.initState();
    _model = new PlansCompareFeedModel();
    _model.init(widget._planType, widget._planId);
    _compareColor = Color(0xFFCCCCCC);
    _setCompare = Set();
  }

  @override
  void dispose() {
    super.dispose();
    _model.dispose();
  }

  @override
  Widget buildItem(BuildContext context) {
    return Scaffold(
        backgroundColor: Colors.white,
        appBar: baseAppBar(
            title: "方案对比",
            centerTitle: true,
            backClick: () {
              if (RouterCenterImpl().findMainRouter().isWithNative()) {
                FlutterBoost.singleton.closeCurrent();
              } else {
                Navigator.of(context).pop();
              }
            }),
        body: SafeArea(
          child: getBody(),
        ));
  }

  getBody() {
    return StreamBuilder(
      stream: _model.liveData.stream,
      initialData: _model.liveData.data ?? null,
      builder: (c, data) {
        if (_model.liveData.data == null) {
          return loadingItem();
        }
        PlansCompareFeed item = data.data;
        if (item == null || item.data == null || item.data.plans == null) {
          return emptyItem(MediaQuery.of(context).size.width,
              MediaQuery.of(context).size.height);
        }
        if (item.error != 0) {
          return errorItem(MediaQuery.of(context).size.width,
              MediaQuery.of(context).size.height, () {
            _model.init(widget._planType, widget._planId);
          });
        }
        return getList(item.data.plans);
      },
    );
  }

  getList(List<Plans> plans) {
    return Column(
      children: <Widget>[
        Expanded(
          child: ListView.builder(
              itemCount: plans.length,
              itemBuilder: (BuildContext context, int position) {
                return PlansCompareFeedItemView(
                    plans[position], this, _setCompare);
              }),
        ),
        Divider(height: 0.5, color: Color(0xFFE5E5E5)),
        GestureDetector(
          behavior: HitTestBehavior.opaque,
          onTap: () => onClickCompare(),
          child: Container(
            margin: EdgeInsets.only(left: 15, right: 15, top: 7.5, bottom: 7.5),
            width: double.maxFinite,
            height: 40,
            decoration: BoxDecoration(
                color: _compareColor, borderRadius: BorderRadius.circular(20)),
            alignment: Alignment.center,
            child: baseText("对比", 14, Colors.white, bold: true),
          ),
        )
      ],
    );
  }

  onClickCompare() {
    if (_compareColor == Color(0xFFCCCCCC)) return;
    RouterCenterImpl().findMainRouter().jumpPage(
        context,
        widget._planType == 1
            ? "level_one_plan_compare_detail"
            : "level_two_plan_compare_deatil",
        {"planIds": _setCompare.toList(), "referrer_tab_name": ""},
        false);
  }

  @override
  checkedItem(int id) {
    if (_setCompare.contains(id)) {
      _setCompare.remove(id);
    } else {
      _setCompare.add(id);
    }
    setState(() {
      if (_setCompare.length == 2) {
        _compareColor = Color(0xff51CDC7);
      } else {
        _compareColor = Color(0xFFCCCCCC);
      }
    });
  }
}
