/*
 * @author lsy
 * @date   2020/7/10
 **/
import 'package:common_utils/common_utils.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';

class NumPlanUtil {
  static String getSale(String sale) {
    int count = 0;
    try {
      count = int.parse(sale);
    } catch (e) {
      print(e.toString());
    }
    if (count < 1000) {
      return "${count}";
    } else if (count < 10000) {
      return "${formatNum(count / 1000.0, 1)}k";
    } else {
      return "${formatNum(count / 10000.0, 1)}w";
    }
  }

  static formatNum(double num, int postion) {
    return (NumUtil.getNumByValueDouble(num, postion)).toStringAsFixed(postion);
  }

  static String getPrice(String min, String max) {
    String price;
    if (min.empty() && max.empty()) {
      price = "暂无报价";
    } else if (min.empty() && !max.empty()) {
      price = "${max}";
    } else if (!min.empty() && max.empty()) {
      price = "${min}";
    } else if (min == max) {
      price = "${max}";
    } else {
      price = "${min}-${max}";
    }
    return price;
  }
}
