/*
 * @author lsy
 * @date   2020/6/29
 **/
import 'dart:async';

import 'package:dio/dio.dart';
import 'package:flutter/services.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:flutter_common/commonModel/toast/NativeToastUtil.dart';
import 'package:flutter_common/commonModel/toast/toast.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/base/BaseUtil.dart';
import 'package:gm_flutter/commonModel/cache/CacheManager.dart';
import 'package:gm_flutter/commonModel/eventbus/SimpleEventBus.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';

import '../../commonModel/App.dart';

class MainManager {
  MethodChannel flutterChannel;
  EventChannel flutterEvent;
  bool isInit = false;

  MainManager._() {}

  static MainManager _mainManager;

  static MainManager getInstance() {
    if (_mainManager == null) {
      _mainManager = MainManager._();
    }
    return _mainManager;
  }

  startInit() {
    if (isInit) {
      return;
    }
    isInit = true;
    print("LSY STATEINIT METHOD AND CHANNEL ");
    flutterChannel = MethodChannel('gm_method_channel');
    flutterEvent = EventChannel('gm_method_event');
    flutterEvent.receiveBroadcastStream().listen((data) {
      if (data is Map) {
        print("LSY STATEINIT OKKK ${data}");
        var map = Map<String, dynamic>.from(data);
        initParams(map);
      }
    });
  }

  void initParams(Map<String, dynamic> map, {VoidCallback callback}) {
    innerSetData(map, APP_NAME);
    innerSetData(map, VERSION);
    innerSetData(map, PLATFORM);
    innerSetData(map, DEVICE_ID);
    innerSetData(map, OS_VERSION);
    innerSetData(map, MODEL);
    innerSetData(map, SCREEN);
    innerSetData(map, LAT);
    innerSetData(map, LNG);
    innerSetData(map, CHANNEL);
    innerSetData(map, MANUFACTURER);
    innerSetData(map, UUID);
    innerSetData(map, ANDROID_DEVICE_ID);
    innerSetData(map, CURRENT_CITY_ID);
    innerSetData(map, RELEASE);
    innerSetData(map, IDFA);
    innerSetData(map, IDFV);
    innerSetData(map, IS_WIFI);
    innerSetData(map, HARDWARE_MODEL);
    innerSetData(map, USER_ID);
    innerSetData(map, USER_AGENT);

    innerSetData(map, BASE_URL);
    DioUtil.getInstance();
    if (bool.fromEnvironment("dart.vm.product")) {
      if (map[BASE_URL] != null &&
          map[BASE_URL] != Api.getInstance().getBaseUrl()) {
        CacheManager.getInstance().get(MEMORY_CACHE).save(URL_ISCHANE, "yes");
        DioUtil.setDefOptions(
            baseUrl: "${map[BASE_URL]}/", agent: map[USER_AGENT]);
        DioUtil.getInstance().changeOpt();
        SimpleEventBus.instance()
            .notifyListener("clueModel|Plan|PlanPage", "init");
      }
    }

    innerSetData(map, COOKIE);
    if (map[USER_ID] == null || "${map[USER_ID]}".isEmpty) {
      CacheManager.getInstance().get(MEMORY_CACHE).save(USER_ID, null);
    }
    if (map[COOKIE] == null || "${map[COOKIE]}".isEmpty) {
      CacheManager.getInstance().get(MEMORY_CACHE).save(COOKIE, null);
    }
    print(
        "LSY QQWWEERRTTYY ${CacheManager.getInstance().get(MEMORY_CACHE).get(COOKIE)}"
        "  ${CacheManager.getInstance().get(MEMORY_CACHE).get(COOKIE) is String}");

//    SimpleEventBus.instance().notifyListener("PlanPage!initState", "");
  }

  void innerSetData(Map<String, dynamic> map, String str) {
    if (map[str] != null && "${map[str]}".isNotEmpty) {
      CacheManager.getInstance().get(MEMORY_CACHE).save(str, "${map[str]}");
    }
  }

  void buriedEvent(String name, Map<String, dynamic> map) {
    if (!isInit) {
      return;
    }
    if (flutterChannel != null) {
      flutterChannel.invokeMethod("buried-${name}", map);
    }
  }

  void catchErrorToBugly(String err) {
    if (!isInit) {
      return;
    }
    if (flutterChannel != null) {
      flutterChannel.invokeMethod("wrong_report_bugly", err ?? "");
    }
  }

  void jumpToSetting() {
    if (!isInit) {
      return;
    }
    if (flutterChannel != null) {
      flutterChannel.invokeMethod("check_system_settings", "");
    }
  }

  void showToast(String text) {
    if (isInit) {
      flutterChannel.invokeMethod("toast_message", text);
    } else {
      NativeToastUtil.showNativeToast(text);
    }
  }
}
