/*
 * @author lsy
 * @date   2020-01-02
 **/
import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:flutter_common/flutter_common.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';

class PlanBarView extends StatelessWidget {
  final LiveData<List> managerLive;
  final Function(int showIndex) managerListener;
  final ChangeNotifier notifier;
  int showIndex = -1;
  List normalData = ["全部项目", "智能筛选", "筛选"];

  PlanBarView(this.managerLive, this.managerListener, this.notifier) {
    if (!notifier?.hasListeners) {
      notifier?.addListener(() {
        showIndex = -1;
        managerListener(-1);
        managerLive.notifyView(managerLive.data ?? normalData);
      });
    }
  }

  @override
  Widget build(BuildContext context) {
    return managerTop(context);
  }

  managerTop(BuildContext context) {
    return Container(
        width: double.maxFinite,
        height: 45,
        child: StreamBuilder<List>(
          stream: managerLive.stream,
          initialData: managerLive.data ?? normalData,
          builder: (c, data) {
            if (data.data.length != 3) {
              return Container();
            }
            return Row(
              children: <Widget>[
                item(data.data[0], 0),
                item(data.data[1], 1),
                item(data.data[2], 2),
              ],
            );
          },
        ));
  }

  Widget item(String text, int index) {
    return Expanded(
      child: GestureDetector(
        behavior: HitTestBehavior.opaque,
        onTap: () {
          if (index == showIndex) {
            showIndex = -1;
          } else {
            showIndex = index;
          }
          managerListener(showIndex);
          managerLive.notifyView(managerLive.data ?? normalData);
        },
        child: Container(
          alignment: Alignment.center,
          height: double.maxFinite,
          child: Row(
            mainAxisSize: MainAxisSize.min,
            children: <Widget>[
              Container(
                height: double.maxFinite,
                alignment: Alignment.center,
                child: baseText(text, 14,
                    index == showIndex ? Color(0xff3FB5AF) : Color(0xff666666)),
              )
              ,
              Container(
                width: 10,
                alignment: Alignment.center,
                height: double.maxFinite,
                child: Container(
                  width: 6,
                  height: 3.5,
                  child: index == showIndex
                      ? Image.asset("assets/top_arrow.png")
                      : Image.asset("assets/bottom_arrow.png"),
                ),
              )
            ],
          ),
        ),
      ),
    );
  }
}
