/*
 * @author lsy
 * @date   2020/7/2
 **/
import 'dart:io';

import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/page/plan/PlanItem.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanFeedBean.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/eventbus/SimpleEventBus.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

import 'TopListModel.dart';

class TopList extends StatefulWidget {
  final int id;
  double topHeight;
  final String rankId;
  String tabName;

  TopList(this.rankId, this.id, this.topHeight, this.tabName);

  @override
  State<StatefulWidget> createState() => TopListState();
}

class TopListState extends State<TopList> with AutomaticKeepAliveClientMixin {
  RefreshController refreshController = RefreshController();
  TopListModel _model = TopListModel();
  Function(String str) refresh;

  @override
  void initState() {
    super.initState();
    _model.tagId = "${widget.id}";
    _model.rankId = widget.rankId;
    _model.getData(true);
    refresh = (str) {
      _model.stateLive.notifyView(LOADING);
      _model.getData(true);
    };
    SimpleEventBus.instance().resignEvent("TopList", refresh);
  }

  @override
  void dispose() {
    refreshController.dispose();
    _model.dispose();
    SimpleEventBus.instance().unResignEvent("TopList", refresh);
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    super.build(context);
    return baseStateView(MediaQuery.of(context).size.width,
        MediaQuery.of(context).size.height, _model.stateLive, home(), () {
      _model.getData(true);
    }, paddingTop: widget.topHeight);
  }

  Widget home() {
    return baseRefreshView(refreshController, () {}, null, null,
        customScrollView: CustomScrollView(
//          physics: NeverScrollableScrollPhysics(),
          physics: ClampingScrollPhysics(),
//          shrinkWrap: true,
          slivers: <Widget>[
            SliverToBoxAdapter(
              child: Container(
                height: widget.topHeight - 12,
              ),
            ),
//            extend.SliverOverlapInjector(
//              handle: NestedScrollView.sliverOverlapAbsorberHandleFor(context),
//            ),
            SliverToBoxAdapter(
              child: Container(
                height: 6,
                color: Color(0xffF7F6FA),
              ),
            ),
            StreamBuilder<List<Plans>>(
              stream: _model.datasLive.stream,
              initialData: _model.datas ?? [],
              builder: (c, data) {
                if (data.data.isEmpty && _model.page > 1) {
                  refreshController.loadNoData();
                } else {
                  refreshController.loadComplete();
                }
                return SliverFixedExtentList(
                  itemExtent: 100,
                  delegate: SliverChildBuilderDelegate(
                    (BuildContext context, int index) {
                      return PlanItem(
                          _model.datas[index], index, false, widget.tabName);
                    },
                    childCount: _model.datas.length,
                  ),
                );
              },
            ),
            StreamBuilder<List<Plans>>(
              stream: _model.datasLive.stream,
              initialData: _model.datas ?? [],
              builder: (c, data) {
                double height = MediaQuery.of(context).size.height -
                    40 -
                    100 * _model.datas.length;
                return SliverToBoxAdapter(
                  child: Container(
                    height: height < 0 ? 0 : height,
                  ),
                );
              },
            ),
          ],
        ), onLoading: () {
      _model.loadMore();
    }, pullDown: false, pullUp: true, loadMoreColor: Color(0xffF7F6FA));
  }

  @override
  bool get wantKeepAlive => true;
}
