/*
 * @author lsy
 * @date   2020/7/2
 **/

import 'dart:async';
import 'dart:ui';

import 'package:flutter/cupertino.dart';
import 'package:extended_nested_scroll_view/extended_nested_scroll_view.dart'
    as extend;
import 'package:flutter/material.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:gm_flutter/ClueModel/page/common/StickyTabBarDelegate.dart';
import 'package:gm_flutter/ClueModel/page/top/TopModel.dart';
import 'package:gm_flutter/ClueModel/util/PosUtil.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';
import 'package:gm_flutter/commonModel/eventbus/SimpleEventBus.dart';
import 'package:gm_flutter/commonModel/net/DioUtil.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';
import 'package:gm_flutter/commonModel/view/baseRefreshIndicator.dart';
import 'package:gm_flutter/main.mark.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

import 'TopList.dart';

class TopPage extends StatefulWidget {
  String rank_type;
  String id;
  String title;

  TopPage(Map<String, dynamic> map) {
    print("LSY ${map.toString()}");
    this.rank_type = map["rank_type"];
    this.id = map["id"];
    this.title = map["title"];
  }

  @override
  State<StatefulWidget> createState() => TopPageState();
}

class TopPageState extends BaseState<TopPage> with TickerProviderStateMixin {
  RefreshController refreshController = RefreshController();
  TopModel _model = TopModel();
  int index = 0;
  TabController tabController;

  @override
  void initState() {
//    DioUtil.getInstance().setProxy("172.30.8.245");
    _model.rank_type = widget.rank_type;
    init();
    super.initState();
  }

  void init() {
    _model.init(() {
      _initTabBar();
    });
  }

  @override
  void dispose() {
    _model.dispose();
    tabController?.removeListener(tabControlerListener);
    tabController?.dispose();
    refreshController.dispose();
    super.dispose();
  }

  void _initTabBar() {
    if (tabController != null) {
      tabController.removeListener(tabControlerListener);
    }
    tabController = TabController(
        initialIndex: index, length: _model.tabs.length, vsync: this);
    tabController.addListener(tabControlerListener);
    setState(() {});
  }

  @override
  Widget buildItem(BuildContext context) {
    return Scaffold(
      body: baseStateView(
          MediaQuery.of(context).size.width,
          MediaQuery.of(context).size.height,
          _model.stateLive,
          Container(
            child: BaseNestedScrollViewRefreshIndicator(
                onRefresh: () async {
                  Completer completer = new Completer();
                  _model.init(() {
                    _initTabBar();
                    SimpleEventBus.instance().notifyListener("TopList", "");
                    completer.complete();
                  });
                  return completer.future;
                },
                child: homeWarp()),
          ), () {
        init();
      },
          paddingTop:
              MediaQueryData.fromWindow(window).padding.top + kToolbarHeight),
    );
  }

  Widget homeWarp() {
    return Stack(
      children: <Widget>[
        Container(
          width: MediaQuery.of(context).size.width,
          height: MediaQuery.of(context).size.height,
          child: NotificationListener(
            onNotification: (scrollNotification) {
              if (scrollNotification is KeepAliveNotification ||
                  scrollNotification is OverscrollIndicatorNotification) {
                return false;
              }
              if (scrollNotification is ScrollUpdateNotification &&
                  scrollNotification.metrics.axisDirection.index == 2) {}
              if (scrollNotification.depth == 0) {
                if (scrollNotification.metrics.pixels > 80) {
                  _model.textLive.notifyView(
                      (scrollNotification.metrics.pixels - 80) / 40 > 1.0
                          ? 1.0
                          : (scrollNotification.metrics.pixels - 80) / 40);
                } else {
                  _model.textLive.notifyView(0.0);
                }
              } else if (scrollNotification.depth == 2) {
                if (scrollNotification.metrics.pixels < 50 &&
                    scrollNotification.metrics.pixels > 0) {
                  _model.textLive.notifyView(1.0);
                }
              }
              return false;
            },
            child: home(),
          ),
        ),
        baseSliverBack(() {
          if (RouterCenterImpl().findMainRouter().isWithNative()) {
            FlutterBoost.singleton.closeCurrent();
          } else {
            Navigator.of(context).pop();
          }
        }),
        baseSliverTitle("${widget.title}", MediaQuery.of(context).size.width,
            _model.textLive)
      ],
    );
  }

  Widget home() {
    List<Widget> list = [];
    var d = MediaQueryData.fromWindow(window).padding.top;
    for (int i = 0; i < _model.tabs.length; i++) {
      list.add(extend.NestedScrollViewInnerScrollPositionKeyWidget(
          Key("Tab${i}"),
          TopList(widget.id, _model.tabs[i].id, kToolbarHeight + d,
              _model.tabs[i].name)));
    }
    return extend.NestedScrollView(
        innerScrollPositionKeyBuilder: () {
          String index = 'Tab${tabController.index.toString()}';
          return Key(index);
        },
        headerSliverBuilder: (BuildContext context, bool innerBoxIsScrolled) {
          return <Widget>[
            SliverOverlapAbsorber(
                handle: extend.NestedScrollView.sliverOverlapAbsorberHandleFor(
                    context),
                sliver: baseSliverAppBar(_model.imageUrl, height: 175)),
            SliverPersistentHeader(
              pinned: true,
              delegate: StickyTabBarDelegate(
                  child: Container(
                height: 40,
                color: Colors.white,
                child: baseTabBar(tabController, getTabs(), (index) {
                  _model.selectTab(index);
                }),
              )),
            ),
          ];
        },
        body: TabBarView(controller: tabController, children: list));
  }

  List<Widget> getTabs() {
    List<Widget> list = [];
    for (int i = 0; i < _model.tabs.length; i++) {
      list.add(baseTabBarItem(_model.tabs[i].name,
          leftPadding: i == 0 ? 24 : 28,
          rightPadding: i == _model.tabs.length - 1 ? 24 : 28));
    }
    return list;
  }

  void tabControlerListener() {
    if (index != tabController.index) {
      index = tabController.index;
    }
  }
}
