class ProjectDetailsItem {
  int error;
  String message;
  String extra;
  String errorExtra;
  UserType userType;
  Data data;

  ProjectDetailsItem(
      {this.error,
      this.message,
      this.extra,
      this.errorExtra,
      this.userType,
      this.data});

  ProjectDetailsItem.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    errorExtra = json['error_extra'];
    userType = json['user_type'] != null
        ? new UserType.fromJson(json['user_type'])
        : null;
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    data['error_extra'] = this.errorExtra;
    if (this.userType != null) {
      data['user_type'] = this.userType.toJson();
    }
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    return data;
  }
}

class UserType {
  UserType();

  UserType.fromJson(Map<String, dynamic> json) {}

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    return data;
  }
}

class Data {
  int id;
  String name;
  List<Groups> groups;

  Data({this.id, this.name, this.groups});

  Data.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    if (json['groups'] != null) {
      groups = new List<Groups>();
      json['groups'].forEach((v) {
        groups.add(new Groups.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    if (this.groups != null) {
      data['groups'] = this.groups.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Groups {
  String name;
  List<Attrs> attrs;

  Groups({this.name, this.attrs});

  Groups.fromJson(Map<String, dynamic> json) {
    name = json['name'];
    if (json['attrs'] != null) {
      attrs = new List<Attrs>();
      json['attrs'].forEach((v) {
        attrs.add(new Attrs.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['name'] = this.name;
    if (this.attrs != null) {
      data['attrs'] = this.attrs.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Attrs {
  int attrId;
  String attrName;
  String attrValue;

  Attrs({this.attrId, this.attrName, this.attrValue});

  Attrs.fromJson(Map<String, dynamic> json) {
    attrId = json['attr_id'];
    attrName = json['attr_name'];
    attrValue = json['attr_value'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['attr_id'] = this.attrId;
    data['attr_name'] = this.attrName;
    data['attr_value'] = this.attrValue;
    return data;
  }
}
