/*
 * @Author: zx 
 * @Date: 2020-07-03 13:53:16 
 * @Last Modified by: zx
 * @Last Modified time: 2020-07-04 12:48:35
 */
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/picker/base/BaseCenterPicker.dart';
import 'package:gm_flutter/ClueModel/server/entity/DiscussLowPriceModelBean.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/ClueModel/page/DiscussLowPrice/DiscussLowPriceModel.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';
import 'package:gm_flutter/commonModel/base/BaseUtil.dart';
import 'package:gm_flutter/main.mark.dart';

class DiscussLowPricePopView {
  static void showPopView(BuildContext content, String pageName, String planId,
      String hospitalId, String doctorId) {
    BaseCenterPicker()
      ..setPicker(_PopView(pageName, planId, hospitalId, doctorId))
      ..show(content);
  }
}

class _PopView implements ICenterPicker {
  String planId;
  String hospitalId;
  String doctorId;
  String pageName;

  _PopView(this.pageName, this.planId, this.hospitalId, this.doctorId);

  VoidCallback dismissCallback;
  double contentWidth;
  DiscussLowPriceModel _model = new DiscussLowPriceModel();
  @override
  Widget build(BuildContext context, int alp) {
    contentWidth = MediaQuery.of(context).size.width - 72;
    return StreamBuilder<Pair<int, DiscussLowPriceModelBean>>(
        stream: _model.popViewLive.stream,
        initialData: _model.popViewLive.data ?? Pair(LOADING, null),
        builder: (c, data) {
          if (data.data.first == LOADING) {
            return loadingItem();
          }
          if (data.data.second == null || data.data.first == FAIL) {
            return errorItem(contentWidth, 308.5, () {});
          }
          return Opacity(
              opacity: alp / 255.0,
              child: Container(
                width: contentWidth,
                height: _model.popViewLive.data.second.title.length > 13
                    ? 377.5
                    : 325.5,
                child: Stack(
                    alignment: AlignmentDirectional.topCenter,
                    children: <Widget>[
                      Positioned(
                        top: 42.5,
                        child: setupBodyView(),
                      ),
                      Positioned(
                          top: 62.5,
                          right: 20,
                          width: 15,
                          height: 14,
                          child: GestureDetector(
                            onTap: () {
                              dismissCallback();
                            },
                            child: Image.asset(
                                'assets/discuss_loe_price_cancel.png'),
                          )),
                      Container(
                          width: 85,
                          height: 85,
                          decoration: BoxDecoration(boxShadow: [
                            BoxShadow(
                                color: Colors.black12,
                                offset: Offset(0.0, 1.0),
                                blurRadius: 15.0,
                                spreadRadius: 1.0)
                          ], shape: BoxShape.circle),
                          child: Container(
                            decoration: BoxDecoration(
                              shape: BoxShape.circle,
                            ),
                            child: Image.network(
                                _model.popViewLive.data.second.icon,
                                fit: BoxFit.cover),
                          )
//                        ClipOval(
//                          child: Image.network(
//                              _model.popViewLive.data.second.icon,
//                              fit: BoxFit.cover),
//                        ),
                          )
                    ]),
              ));
        });
  }

  setupBodyView() {
    return Container(
      width: contentWidth,
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(10),
        color: Colors.white,
      ),
      child: Container(
        alignment: Alignment.center,
        margin: EdgeInsets.only(bottom: 0, top: 44),
        child: detailView(),
      ),
    );
  }

  detailView() {
    return Column(
        crossAxisAlignment: CrossAxisAlignment.center,
        mainAxisSize: MainAxisSize.min,
        mainAxisAlignment: MainAxisAlignment.center,
        children: <Widget>[
          Container(
            margin: EdgeInsets.only(bottom: 13.5),
            alignment: AlignmentDirectional.center,
            child: Row(
                mainAxisSize: MainAxisSize.min,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: <Widget>[
                  Container(
                      width: 16,
                      height: 16,
                      child: Image.asset(
                        'assets/discuss_loe_price_like.png',
                      )),
                  Container(
                    margin: EdgeInsets.only(left: 4),
                    child: baseText(_model.popViewLive.data.second.tip, 14,
                        Color(0xff848484)),
                  )
                ]),
          ),
          Container(
              width: contentWidth,
              alignment: Alignment.center,
              margin: EdgeInsets.only(bottom: 25),
              child: baseText("${_model.popViewLive.data.second.title}", 18,
                  Color(0xff464646),
                  bold: true, textAlign: TextAlign.center, maxLines: 2)),
          Container(
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(7),
                color: Color(0xffECECEC),
              ),
              alignment: Alignment.center,
              margin: EdgeInsets.only(bottom: 12),
              width: contentWidth - 70,
              height: 37,
              child: baseText(_model.popViewLive.data.second.authorizePhone, 16,
                  Color(0xff484848))),
          Container(
            alignment: Alignment.center,
            margin: EdgeInsets.only(bottom: 14),
            width: contentWidth - 70,
            height: 37,
            decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(7),
                color: Color(0xff20BDBB)),
            child: Text("一键授权（加密）",
                textAlign: TextAlign.start,
                textScaleFactor: 1.0,
                style: TextStyle(
                  decoration: TextDecoration.none,
                  fontSize: 15,
                  color: Color(0xffffffff),
                  fontStyle: FontStyle.normal,
                  fontWeight: FontWeight.w700,
                  shadows: <Shadow>[
                    Shadow(color: Color(0xff007872), offset: Offset(0, 2))
                  ],
                )),
          ).gestureDetector(() {
            // 一键授权
            _model.givePhoneAuth(
                _model.popViewLive.data.second.leadPhoneRequestId, () {
              dismissCallback();
            });
          }),
          Container(
              margin: EdgeInsets.only(bottom: 23.5),
              child: baseText('更美为您提供号码保护，对方看不到您的真实手机号', 11, Color(0xff999999))),
        ]);
  }

  Map<String, dynamic> phobosData() {
    Map<String, dynamic> params = Map();
    params['page_name'] = this.pageName;
    if (this.hospitalId.length > 0) {
      params['popup_name'] = 'interested_hospital';
    } else if (this.doctorId.length > 0) {
      params['popup_name'] = 'interested_doctor';
    } else {
      params['popup_name'] = 'interested_plan';
    }
    return params;
  }

  @override
  void dispose() {
    _model.dispose();
  }

  @override
  void initState(VoidCallback dismissCall, BuildContext context) {
    this.dismissCallback = dismissCall;
    _model.fetchPopviewData(this.planId, this.hospitalId, this.doctorId, () {
      dismissCallback();
    });
    RouterCenterImpl().findMainRouter().buriedEvent("popup_view", phobosData());
  }
}
