/*
 * @author dx
 * @date   2020/6/29
 **/
import 'dart:async';
import 'dart:math';
import 'dart:ui';

import 'package:cached_network_image/cached_network_image.dart';
import 'package:extended_nested_scroll_view/extended_nested_scroll_view.dart'
    as extend;
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/picker/base/BaseBottomPicker.dart';
import 'package:gm_flutter/ClueModel/page/DiscussLowPrice/DiscussLowPricePopView.dart';
import 'package:gm_flutter/ClueModel/page/common/StickyTabBarDelegate.dart';
import 'package:gm_flutter/ClueModel/page/levelOne/LevelOneList.dart';
import 'package:gm_flutter/ClueModel/page/levelOne/LevelOneModel.dart';
import 'package:gm_flutter/ClueModel/page/mechanismBox/MechanismBoxPage.dart';
import 'package:gm_flutter/commonModel/App.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/cache/CacheManager.dart';
import 'package:gm_flutter/commonModel/eventbus/SimpleEventBus.dart';
import 'package:gm_flutter/commonModel/net/DioUtil.dart';
import 'package:gm_flutter/commonModel/view/baseRefreshIndicator.dart';
import 'package:gm_flutter/main.mark.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class LevelTwoPage extends StatefulWidget {
  int planId;
  final String PAGE_NAME = "level_two_plan_deatil";

  LevelTwoPage(Map<String, dynamic> params) {
    planId = params['planId'];
  }

  @override
  State<StatefulWidget> createState() => LevelTwoState();
}

class LevelTwoState extends BaseState<LevelTwoPage>
    with TickerProviderStateMixin {
  LevelOneModel _model = new LevelOneModel();
  RefreshController _refreshController = RefreshController();
  GlobalKey keyTop = new GlobalKey();
  GlobalKey key1 = new GlobalKey();
  double screenWidth;
  List<Widget> oneList = new List();
  int lastPageIndex = 0;

  TabController tabController;

  int index = 0;

  @override
  void initState() {
    // DioUtil.getInstance().setProxy("172.30.8.245");
    super.initState();
    _model.plan_id = widget.planId;
    _model.init(() {
      _initTabBar();
    });
  }

  void _initTabBar() {
    if (tabController != null) {
      tabController.removeListener(tabControlerListener);
    }
    tabController = TabController(
        initialIndex: index, length: _model.tabsList.length, vsync: this);
    tabController.addListener(tabControlerListener);
    setState(() {});
  }

  @override
  void dispose() {
    tabController?.removeListener(tabControlerListener);
    tabController?.dispose();
    _model.dispose();
    _refreshController.dispose();
    super.dispose();
  }

  void tabControlerListener() {
    if (index != tabController.index) {
      index = tabController.index;
    }
  }

  @override
  Widget buildItem(BuildContext context) {
    oneList.clear();
    oneList.add(good());
    oneList.add(rect());
    oneList.add(explain());
    oneList.add(Container(
      height: 5,
      color: Color(0xffF7F6FA),
    ));
    screenWidth = MediaQuery.of(context).size.width;
    return Scaffold(
        backgroundColor: Colors.white,
        body: SafeArea(
            top: false,
            child: baseStateView(
                MediaQuery.of(context).size.width,
                MediaQuery.of(context).size.height,
                _model.stateLive,
                Container(
                  child: BaseNestedScrollViewRefreshIndicator(
                      onRefresh: () async {
                        Completer completer = new Completer();
                        _model.init(() {
                          _initTabBar();
                          SimpleEventBus.instance()
                              .notifyListener("LevelOneList", "");
                          completer.complete();
                        });
                        return completer.future;
                      },
                      child: Column(
                        children: <Widget>[
                          Expanded(
                            child: newHomeWarp(),
                          ),
                          bottomWidget(),
                        ],
                      )),
                ), () {
              _model.stateLive.notifyView(LOADING);
              _model.init(() {
                _initTabBar();
              });
            },
                paddingTop: MediaQueryData.fromWindow(window).padding.top +
                    kToolbarHeight)));
  }

  Widget newHomeWarp() {
    return Stack(
      children: <Widget>[
        Container(
            width: MediaQuery.of(context).size.width,
            height: MediaQuery.of(context).size.height,
            child: NotificationListener(
              onNotification: (scrollNotification) {
                if (scrollNotification is KeepAliveNotification ||
                    scrollNotification is OverscrollIndicatorNotification) {
                  return false;
                }
                if (scrollNotification is ScrollUpdateNotification &&
                    scrollNotification.metrics.axisDirection.index == 2) {}
                if (scrollNotification.depth == 0) {
                  if (scrollNotification.metrics.pixels > 80) {
                    _model.textLive.notifyView(
                        (scrollNotification.metrics.pixels - 80) / 40 > 1.0
                            ? 1.0
                            : (scrollNotification.metrics.pixels - 80) / 40);
                  } else {
                    _model.textLive.notifyView(0.0);
                  }
                } else if (scrollNotification.depth == 2) {
                  if (scrollNotification.metrics.pixels < 50 &&
                      scrollNotification.metrics.pixels > 0) {
                    _model.textLive.notifyView(1.0);
                  }
                }
                return false;
              },
              child: newHome(),
            )),
        Positioned(
          top: 44,
          left: 60,
          child: Container(
            alignment: Alignment.center,
            width: MediaQuery.of(context).size.width - 100,
            child: baseText(_model.name, 18, Color(0xff333333)),
          ),
        ),
        baseSliverBack(() {
          Navigator.of(context).pop();
        }),
      ],
    );
  }

  Widget newHome() {
    List<Widget> list = [];
    var d = MediaQueryData.fromWindow(window).padding.top;
    for (int i = 0; i < _model.tabsList.length; i++) {
      list.add(extend.NestedScrollViewInnerScrollPositionKeyWidget(
          Key("Tab${i}"),
          LevelOneList(1, widget.PAGE_NAME, widget.planId,
              _model.tabsList[i].tabType, kToolbarHeight + d)));
    }
    final double statusBarHeight = MediaQuery.of(context).padding.top;
    final double pinnedHeaderHeight = statusBarHeight + kToolbarHeight;
    return extend.NestedScrollView(
        innerScrollPositionKeyBuilder: () {
          String index = 'Tab${tabController.index.toString()}';
          return Key(index);
        },
        headerSliverBuilder: (BuildContext context, bool innerBoxIsScrolled) {
          return <Widget>[
            SliverOverlapAbsorber(
                handle: extend.NestedScrollView.sliverOverlapAbsorberHandleFor(
                    context),
                sliver: baseSliverAppBar(_model.imageUrl,
                    height: 0, needpic: false)),
            SliverList(
                delegate: SliverChildBuilderDelegate((BuildContext c, int i) {
              if (i == 0) {
                return Container(
                  height: pinnedHeaderHeight,
                );
              }
              return oneList[i - 1];
            }, childCount: oneList.length + 1)),
            SliverPersistentHeader(
              pinned: true,
              delegate: StickyTabBarDelegate(
                  child: Container(
                height: 40,
                color: Colors.white,
                child: baseTabBar(tabController, getTabs(), (index) {
                  Map<String, dynamic> map = {};
                  map["page_name"] = "level_two_plan_deatil";
                  map["referrer"] = "";
                  map["referrer_id"] = "";
                  map["referrer_link"] = ["plan_home"];
                  map["from_tab_name"] = "全部";
                  map["tab_name"] = index == 0 ? '机构' : '医生';
                  map["position"] = 1;
                  RouterCenterImpl()
                      .findMainRouter()
                      .buriedEvent("on_click_tab", map);
                  _model.selectTab(index);
                }, scroll: false),
              )),
            ),
          ];
        },
        body: TabBarView(controller: tabController, children: list));
  }

  List<Widget> getTabs() {
    List<Widget> list = [];
    for (int i = 0; i < _model.tabsList.length; i++) {
      list.add(baseTabBarItem(_model.tabsList[i].name,
          leftPadding: i == 0 ? 24 : 28,
          rightPadding: i == _model.tabsList.length - 1 ? 24 : 28));
    }
    return list;
  }

  Widget good() {
    if (_model.planoverItem == null) {
      return Container(
        height: 54,
      );
    }
    return Padding(
      padding: EdgeInsets.only(left: 15.0, right: 15.0, bottom: 20),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisSize: MainAxisSize.max,
        children: <Widget>[
          ClipRRect(
            borderRadius: BorderRadius.circular(6),
            child: Container(
              color: Color(0xffF9F8FB),
              width: 86,
              height: 86,
              padding: EdgeInsets.all(1),
              child: ClipRRect(
                  borderRadius: BorderRadius.circular(6),
                  child: Container(
                    width: 86,
                    height: 86,
                    color: Colors.white,
                    child: CachedNetworkImage(
                      imageUrl: _model.planoverItem.banner.imageUrl,
                      width: 86,
                      height: 86,
                      fit: BoxFit.cover,
                    ),
                  )),
            ),
          ),
          Expanded(
            child: Padding(
                padding: EdgeInsets.only(left: 12, top: 5),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  mainAxisSize: MainAxisSize.max,
                  children: <Widget>[
                    Text(_model.planoverItem.name,
                        style: TextStyle(
                            color: Color(0xff333333),
                            fontSize: 15,
                            fontWeight: FontWeight.bold)),
                    Padding(padding: EdgeInsets.only(top: 5)),
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      verticalDirection: VerticalDirection.up,
                      children: <Widget>[
                        Text('指导价：',
                            style: TextStyle(
                                color: Color(0xff999999), fontSize: 12)),
                        Expanded(
                          child: baseText(_model.planoverItem.guidePrice, 12,
                              Color(0xffFF5963)),
                        )
                      ],
                    )
                  ],
                )),
          )
        ],
      ),
    );
  }

  Widget rect() {
    if (_model.planoverItem == null) {
      return Container(
        height: 62,
      );
    }
    List<Widget> list = List();
    int i = 0;
    _model.planoverItem.overviewAttrs.forEach((element) {
      list.add(Expanded(
        child: Container(
          alignment: Alignment.center,
          child: Column(
            mainAxisSize: MainAxisSize.min,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: <Widget>[
              baseText(element.attrName, 14, Color(0xff282828), bold: true),
              baseText(element.attrValue, 11, Color(0xff999999)),
            ],
          ),
        ),
      ));
      if (i != _model.planoverItem?.overviewAttrs.length - 1) {
        list.add(Container(
          width: 0.5,
          height: 18,
          color: Color(0xFFE5E5E5),
        ));
      }
      i++;
    });
    return Container(
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(4),
        color: Color(0xffF9F8FB),
      ),
      width: double.maxFinite,
      height: 62,
      margin: EdgeInsets.only(left: 15, right: 15, bottom: 20),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: list,
      ),
    );
  }

  Widget explain() {
    List<Widget> list = [];
    list.add(Container(
      height: 31,
      child: Row(
        children: <Widget>[
          baseText("项目说明", 15, Color(0xff282828)),
          Expanded(
            child: Container(),
          ),
          GestureDetector(
            onTap: () {
              RouterCenterImpl().findMainRouter().jumpPage(
                  context,
                  "level_one_plan_instruction",
                  {"planId": widget.planId},
                  false);
            },
            behavior: HitTestBehavior.opaque,
            child: baseText("了解更多", 12, Color(0xff3FB5AF)),
          )
        ],
      ),
    ));
    if (_model.planoverItem != null) {
      _model.planoverItem.explanationAttrs.forEach((element) {
        list.add(Container(
          margin: EdgeInsets.only(bottom: 15),
          child: Row(
            children: <Widget>[
              Container(
                  constraints: BoxConstraints(
                    maxWidth: 52,
                  ),
                  child: Text(
                    element.attrName,
                    textScaleFactor: 1.0,
                    softWrap: true,
                    maxLines: 1,
                    overflow: TextOverflow.ellipsis,
                    style: TextStyle(
                        decoration: TextDecoration.none,
                        fontSize: 13,
                        color: Color(0xff999999),
                        fontStyle: FontStyle.normal,
                        fontWeight: FontWeight.w400),
                  )),
              Expanded(
                child: Container(
                  margin: EdgeInsets.only(left: 12),
                  child: Text(
                    element.attrValue,
                    textScaleFactor: 1.0,
                    softWrap: false,
                    overflow: TextOverflow.ellipsis,
                    style: TextStyle(
                        decoration: TextDecoration.none,
                        fontSize: 13,
                        color: Color(0xff666666),
                        fontStyle: FontStyle.normal,
                        fontWeight: FontWeight.w400),
                  ),
//                baseText(element.attrValue, 13, Color(0xff666666)
//                ),
                ),
              )
            ],
          ),
        ));
      });
    }
    return Container(
      margin: EdgeInsets.only(left: 15, right: 15, bottom: 20),
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: list,
      ),
    );
  }

  // 底部按钮
  Widget bottomWidget() {
    return Align(
        alignment: Alignment.bottomCenter,
        child: Container(
          width: double.maxFinite,
          height: 55,
          color: Colors.white,
          child: Row(
            mainAxisSize: MainAxisSize.min,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: <Widget>[
              GestureDetector(
                behavior: HitTestBehavior.opaque,
                onTap: () {
                  RouterCenterImpl().findMainRouter().jumpPage(
                      context,
                      "level_two_plan_compare",
                      {"planType": 2, "planId": widget.planId},
                      false);
                },
                child: Container(
                  margin: EdgeInsets.only(left: 18),
                  width: 30,
                  child: Column(
                    mainAxisSize: MainAxisSize.min,
                    children: <Widget>[
                      Container(
                        width: 22,
                        height: 22,
                        child: Image.asset("assets/vs_black.png"),
                      ),
                      Container(
                        margin: EdgeInsets.only(top: 3),
                        child: baseText("去比较", 10, Color(0xff282828)),
                      )
                    ],
                  ),
                ),
              ),
              GestureDetector(
                  behavior: HitTestBehavior.opaque,
                  onTap: () {
                    if (CacheManager.getInstance()
                                .get(MEMORY_CACHE)
                                .get(USER_ID) ==
                            null &&
                        RouterCenterImpl().findMainRouter().isWithNative()) {
                      RouterCenterImpl()
                          .findMainRouter()
                          .jumpPage(context, "show_login", null, true);
                      return;
                    }
                    BaseBottomPicker()
                      ..setPicker(MechanismBox(widget.planId))
                      ..show(context);
                  },
                  child: Container(
                    margin: EdgeInsets.only(left: 15),
                    width: 135,
                    height: 40,
                    decoration: BoxDecoration(
                        color: Color(0xff51CDC7),
                        borderRadius: BorderRadius.circular(20)),
                    alignment: Alignment.center,
                    child: baseText("咨询", 14, Colors.white, bold: true),
                  )),
              GestureDetector(
                  behavior: HitTestBehavior.opaque,
                  onTap: () {
                    if (CacheManager.getInstance()
                                .get(MEMORY_CACHE)
                                .get(USER_ID) ==
                            null &&
                        RouterCenterImpl().findMainRouter().isWithNative()) {
                      RouterCenterImpl()
                          .findMainRouter()
                          .jumpPage(context, "show_login", null, true);
                      return;
                    }
                    Map<String, dynamic> map = {
                      "page_name": "level_two_plan_deatil",
                      "referrer_link": [],
                      "popup_name": "interested_plan"
                    };
                    RouterCenterImpl()
                        .findMainRouter()
                        .buriedEvent("popup_view", map);
                    DiscussLowPricePopView.showPopView(
                        context, widget.PAGE_NAME, "${widget.planId}", "", "");
                  },
                  child: Container(
                    margin: EdgeInsets.only(left: 15),
                    width: 135,
                    height: 40,
                    decoration: BoxDecoration(
                        color: Color(0xffF96079),
                        borderRadius: BorderRadius.circular(20)),
                    alignment: Alignment.center,
                    child: baseText("获取底价", 14, Colors.white, bold: true),
                  )),
              Expanded(
                child: Container(),
              )
            ],
          ),
        ));
  }
}
