/*
 * @Author: zx 
 * @Date: 2020-06-30 17:40:43 
 * @Last Modified by: zx
 * @Last Modified time: 2020-07-03 13:47:57
 */
import 'dart:convert';
import 'dart:math';

import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:gm_flutter/ClueModel/page/PlanCompareDetail/PlanCompareDetailModel.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanCompareDetail.dart';
import 'package:gm_flutter/ClueModel/util/NumPlanUtil.dart';
import 'package:gm_flutter/ClueModel/view/FiveStarView.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';
import 'package:gm_flutter/main.mark.dart';

class PlanCompareDetailPage extends StatefulWidget {
  String _planIds;

  PlanCompareDetailPage(Map<String, dynamic> params) {
    String planIds = json.encode(params["planIds"]);
    this._planIds = planIds;
  }

  @override
  State<StatefulWidget> createState() => PlanCompareDetailPageState();
}

class PlanCompareDetailPageState extends BaseState<PlanCompareDetailPage> {
  PlanCompareDetailModel _model = new PlanCompareDetailModel();
  double screenWidth;

  @override
  void initState() {
    super.initState();
    _model.init(widget._planIds);
  }

  @override
  void dispose() {
    _model.dispose();
    super.dispose();
  }

  @override
  Widget buildItem(BuildContext context) {
    screenWidth = MediaQuery.of(context).size.width;
    return Scaffold(
      appBar: baseAppBar(
          titleWidget: baseText("对比详情", 18, Color(0xff333333), bold: true),
          centerTitle: true,
          backClick: () {
            if (RouterCenterImpl().findMainRouter().isWithNative()) {
              FlutterBoost.singleton.closeCurrent();
            } else {
              Navigator.of(context).pop();
            }
          }),
      body: reloadPage(),
    );
  }

  Widget reloadPage() {
    return StreamBuilder(
      stream: _model.stateLive.stream,
      initialData: _model.stateLive.data ?? LOADING,
      builder: (c, data) {
        if (data.data == FAIL) {
          return errorItem(MediaQuery.of(context).size.width,
              MediaQuery.of(context).size.height, () {
            _model.stateLive.notifyView(LOADING);
            _model.init(widget._planIds);
          });
        }
        if (data.data == LOADING) {
          return loadingItem();
        }
        return Stack(
          children: <Widget>[
            setupHome(),
            head(),
          ],
        );
      },
    );
  }

  Widget setupHome() {
    return Container(
        child: Column(
      children: <Widget>[
        Container(
          height: 93,
        ),
        Expanded(
            child: Container(
          color: Color(0xffF7F6FA),
          child: StreamBuilder<Pair<int, List<Groups>>>(
              stream: _model.detailLive.stream,
              initialData: _model.detailLive.data ?? Pair(LOADING, null),
              builder: (c, data) {
                if (data.data.first == EMPTY) {
                  return emptyItem(MediaQuery.of(context).size.width,
                      MediaQuery.of(context).size.height);
                }
                return ListView.builder(
                  itemBuilder: (BuildContext context, int index) {
                    if (index == data.data.second.length * 2 - 1) {
                      return Container(
                        height: 40,
                        color: Color(0xffF7F6FA),
                      );
                    }
                    if (index % 2 != 0) {
                      return Container(
                        height: 5,
                        color: Color(0xffF7F6FA),
                      );
                    }
                    int newIndex = (index / 2).floor();
                    Groups group = data.data.second[newIndex];
                    Widget widget;
                    if (group.groupType == 'hot') {
                      widget = planPopularityView(group);
                    } else if (group.groupType == 'normal_attrs') {
                      widget = planNormalEffectiveAttrsView(group);
                    } else if (group.groupType == 'effective_attrs') {
                      widget = planNormalEffectiveAttrsView(group);
                    } else {
                      widget = planNormalEffectiveAttrsView(group);
                    }
                    return Container(
                      color: Colors.white,
                      child: Container(
                        margin: EdgeInsets.only(left: 15, right: 15),
                        child: widget,
                      ),
                    );
                  },
                  itemCount: data.data.second.length * 2,
                );
              }),
        ))
      ],
    ));
  }

  Widget head() {
    return Container(
        decoration: BoxDecoration(
          boxShadow: [
            BoxShadow(
                color: Color(0x08000000),
                offset: Offset(0.0, 2.0),
                blurRadius: 12,
                spreadRadius: 0)
          ],
          color: Colors.white,
        ),
        // key: keyTop,
        width: screenWidth,
        height: 93,
        alignment: Alignment.topLeft,
        child: Container(
          margin: EdgeInsets.only(left: 15, right: 15),
          child: Row(children: <Widget>[
            // 根据 flex系数，分配剩余空间
            Expanded(flex: 1, child: headItem(0)),
            Expanded(flex: 1, child: headItem(1))
          ]),
        ));
  }

  Widget headItem(int index) {
    return StreamBuilder<List<PlansInfoDetail>>(
      stream: _model.headerLive.stream,
      initialData: _model.headerLive.data,
      builder: (c, data) {
        if (data.data == null || data.data.length != 2) {
          return Container();
        }
        var price = NumPlanUtil.getPrice(
            data.data[index].min_price, data.data[index].max_price);
        return Container(
            child: Stack(children: <Widget>[
          Positioned(
              top: 3,
              left: index == 0 ? 0 : 5.5,
              child: Container(
                height: 75,
                width: (screenWidth - 30 - 11) / 2,
                child: Image.asset('assets/plan_compare_detail_info_bg.png',
                    fit: BoxFit.fill),
              )),
          Positioned(
            left: index == 0 ? 12 : 17.5,
            right: index == 0 ? 12 : 6,
            top: 16,
            child: Container(
              width: (screenWidth - 30 - 11) / 2,
              child: baseText(data.data[index].planName, 15, Color(0xff333333),
                  bold: true),
            ),
          ),
          Positioned(
            left: index == 0 ? 12 : 17.5,
            top: 45,
            child: Row(
              mainAxisSize: MainAxisSize.min,
              crossAxisAlignment: CrossAxisAlignment.baseline,
              textBaseline: TextBaseline.alphabetic,
              children: <Widget>[
                price == "暂无报价"
                    ? Container(
                        width: 0,
                        height: 0,
                      )
                    : baseText("¥", 12, Color(0xffFF5963)),
                baseText(price, price == "暂无报价" ? 13 : 15,
                    price == "暂无报价" ? Color(0xff999999) : Color(0xffFF5963),
                    bold: price != "暂无报价")
              ],
            ),
          ),
        ]));
      },
    );
  }

  Widget titleView(String title) {
    return Container(
      height: 25,
      width: screenWidth,
      margin: EdgeInsets.fromLTRB(0, 30, 0, 25),
      alignment: Alignment.center,
      child: Container(
        width: 90,
        height: 25,
        child: Stack(
          alignment: AlignmentDirectional.center,
          children: <Widget>[
            Positioned(
              bottom: 0,
              child: Container(
                width: 90,
                height: 10,
                child: Image.asset("assets/plan_compare_detail_title_bg.png"),
              ),
            ),
            Positioned(
              top: 0,
              child: baseText(title, 20, Color(0xff282828), bold: true),
            )
          ],
        ),
      ),
    );
  }

  Widget planPopularityView(Groups groups) {
    return Container(
        child: Column(
            mainAxisSize: MainAxisSize.min,
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
          titleView(groups.groupName),
          planPopularityBodyView(groups),
        ]));
  }

  Widget planPopularityBodyView(Groups groups) {
    return Container(
        height: 170,
        child: Row(children: <Widget>[
          Expanded(
              flex: 1, child: planPopularityLeftItem(groups.plans[0], groups)),
          Expanded(
              flex: 1, child: planPopularityRightItem(groups.plans[1], groups))
        ]));
  }

  Widget planPopularityLeftItem(Plans plan, Groups groups) {
    return Container(
        height: 170,
        child: Stack(children: <Widget>[
          Positioned(
              right: 20,
              top: 0,
              child: baseText(plan.positiveRate, 21, Color(0xff3FB5AF),
                  bold: true)),
          Positioned(
            right: 20,
            top: 29,
            child: baseText('好评率', 12, Color(0xff666666), bold: false),
          ),
          Positioned(
            right: 20,
            top: 56,
            child: FiveStarView(
              plan.planStart,
              5,
              starAssets: 'assets/plan_compare_detail_green_star_all.png',
              isForward: true,
            ),
          ),
          Positioned(
            right: 20,
            top: 84,
            child: baseText(plan.salesCount, 21, Color(0xff3FB5AF), bold: true),
          ),
          Positioned(
            right: 20,
            top: 108,
            child: baseText('销量', 12, Color(0xff666666), bold: false),
          ),
          Positioned(
              right: 20,
              bottom: 30,
              child: Container(
                height: 7,
                width: 95,
                child: ClipRRect(
                  borderRadius: BorderRadius.circular(3.5),
                  child: Container(
                    color: Color(0xffF7F6FA),
                  ),
                ),
              )),
          Positioned(
            right: 20,
            bottom: 30,
            child: Container(
              width: 95 *
                  sellCount(
                      0,
                      plan,
                      max(int.parse(groups.plans[0].salesCount),
                          int.parse(groups.plans[1].salesCount))),
              height: 7,
              child: ClipRRect(
                borderRadius: BorderRadius.circular(3.5),
                child: Container(
                  color: Color(0xff3FB5AF),
                ),
              ),
            ),
          )
        ]));
  }

  Widget planPopularityRightItem(Plans plan, Groups groups) {
    return Container(
        height: 170,
        child: Stack(children: <Widget>[
          Positioned(
              left: 20,
              top: 0,
              child: baseText(plan.positiveRate, 21, Color(0xffF25874),
                  bold: true)),
          Positioned(
            left: 20,
            top: 29,
            child: baseText('好评率', 12, Color(0xff666666), bold: false),
          ),
          Positioned(
              left: 20,
              top: 56,
              child: Container(
                height: 13,
                width: 81,
                child: FiveStarView(
                  plan.planStart,
                  5,
                  starAssets: 'assets/plan_compare_detail_red_star_all.png',
                ),
              )),
          Positioned(
            left: 20,
            top: 84,
            child: baseText(plan.salesCount, 21, Color(0xffF25874), bold: true),
          ),
          Positioned(
            left: 20,
            top: 108,
            child: baseText('销量', 12, Color(0xff666666), bold: false),
          ),
          Positioned(
              left: 20,
              bottom: 30,
              child: Container(
                height: 7,
                width: 95,
                child: ClipRRect(
                  borderRadius: BorderRadius.circular(3.5),
                  child: Container(
                    color: Color(0xffF7F6FA),
                  ),
                ),
              )),
          Positioned(
            left: 20,
            bottom: 30,
            child: Container(
              width: 95 *
                  sellCount(
                      1,
                      plan,
                      max(int.parse(groups.plans[0].salesCount),
                          int.parse(groups.plans[1].salesCount))),
              height: 7,
              child: ClipRRect(
                borderRadius: BorderRadius.circular(3.5),
                child: Container(
                  color: Color(0xffF25874),
                ),
              ),
            ),
          )
        ]));
  }

  Widget planNormalEffectiveAttrsView(Groups groups) {
    List<Widget> list = new List();
    list.add(titleView(groups.groupName));
    if (groups.plans != null && groups.plans.length == 2) {
      for (int i = 0;
          i < max(groups.plans[0].attrs.length, groups.plans[1].attrs.length);
          i++) {
        list.add(planBaseAttrsView(groups.plans[0], groups.plans[1], i));
      }
    }
    list.add(Container(
      height: 6,
    ));
    return Container(
        child: Column(
            mainAxisSize: MainAxisSize.min,
            mainAxisAlignment: MainAxisAlignment.center,
            children: list));
  }

  Widget planBaseAttrsView(Plans plan1, Plans plan2, int index) {
    return Column(
      mainAxisSize: MainAxisSize.min,
      children: <Widget>[
        planItem(
            index > plan1.attrs.length - 1
                ? "暂无"
                : "${plan1.attrs[index].attrValue}",
            index > plan2.attrs.length - 1
                ? "暂无"
                : "${plan2.attrs[index].attrValue}",
            false),
        Container(
          height: 6,
        ),
        planItem(
            index > plan1.attrs.length - 1
                ? "暂无"
                : "${plan1.attrs[index].attrName}",
            index > plan2.attrs.length - 1
                ? "暂无"
                : "${plan2.attrs[index].attrName}",
            true),
        Container(
          height: 24,
        )
      ],
    );
    ;
  }

  Widget planItem(String left, String right, bool isName) {
    return Row(children: <Widget>[
      Expanded(
        flex: 1,
        child: baseText(left.empty() ? "暂无" : left, isName ? 12 : 14,
            isName ? Color(0xff666666) : Color(0xff3FB5AF),
            bold: isName ? false : true,
            maxLines: 100,
            isWarp: true,
            textAlign: TextAlign.end),
      ),
      Container(
        width: 40,
      ),
      Expanded(
          flex: 1,
          child: baseText(right.empty() ? "暂无" : right, isName ? 12 : 14,
              isName ? Color(0xff666666) : Color(0xffF25874),
              bold: isName ? false : true,
              maxLines: 100,
              isWarp: true,
              textAlign: TextAlign.start))
    ]);
  }

  double sellCount(int index, Plans anotherPlans, int max) {
    int salesCount = int.parse(anotherPlans.salesCount);
    return salesCount / max / 1.0;
  }
}
