/*
 * @author lsy
 * @date   2020/6/29
 **/
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueTApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/LevelOneFeedList.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanOverViewBean.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:gm_flutter/commonModel/util/NativeToast.dart';
import 'package:gm_flutter/commonModel/util/PrintUtil.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';
import 'package:gm_flutter/main.mark.dart';

class LevelOneModel extends BaseModel {
  LiveData<int> stateLive = LiveData();
  LiveData<double> textLive = LiveData();

  RxDispose rxDispose = RxDispose();

  List<Tabs> tabsList = [];
  int plan_id = 0;
  PlanOverData planoverItem;
  String imageUrl = "";
  String name = "";

  void init(VoidCallback callback) {
    ClueTApiImpl.getInstance()
        .getPlanOverView(DioUtil.getInstance().getDio(), plan_id)
        .listen((event) {
          if (event.error == 0) {
            planoverItem = event.data;
            name = event.data.name;
            imageUrl = event.data.banner.imageUrl;
            tabsList = event.data.tabs;
            stateLive.notifyView(ENDLOADING);
            callback();
          } else {
            NativeToast.showNativeToast(event.message);
            stateLive.notifyView(FAIL);
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          PrintUtil.printBug(err);
          stateLive.notifyView(FAIL);
        });
  }

  int currentIndex = 0;

  @override
  void dispose() {
    stateLive.dispost();
    textLive.dispost();
  }

  void selectTab(int index, String tab_name, String from_tab_name) {
    buried_on_click_tab(index, tab_name, from_tab_name);
  }

  buried_on_click_tab(int position, String tab_name, String from_tab_name) {
    Map<String, dynamic> buriedMap;
    buriedMap = {
      "tab_name": tab_name,
      "position": position,
      "from_tab_name": from_tab_name,
    };
    RouterCenterImpl().findMainRouter().buriedEvent("on_click_tab", buriedMap);
  }
}
