// GENERATED CODE - DO NOT MODIFY BY HAND

// **************************************************************************
// ServiceGenerator
// **************************************************************************

import 'dart:convert';

import 'dart:io';

import 'package:rxdart/rxdart.dart';

import 'package:dio/dio.dart';

import 'package:flutter/foundation.dart';

import 'package:gm_flutter/MainRouter/service/remote/entity/TestBean.dart';
import 'package:gm_flutter/MainRouter/service/remote/entity/CityBean.dart';

const bool inProduction = const bool.fromEnvironment("dart.vm.product");

class MainApiImpl {
  static JsonEncoder encoder = JsonEncoder.withIndent('  ');

  static MainApiImpl _instance;

  MainApiImpl._() {}

  static MainApiImpl getInstance() {
    if (_instance == null) {
      _instance = MainApiImpl._();
    }
    return _instance;
  }

  Stream<TestBean> isOk(
    Dio _dio,
  ) {
    return Stream.fromFuture(get(_dio, 'api/demo/test')).flatMap((value) {
      if (value != null &&
          (value.statusCode >= 200 && value.statusCode < 300)) {
        return Stream.fromFuture(compute(parseTestBean, value.toString()));
      } else {
        throw Exception("--未知网络错误--");
      }
    });
  }

  Stream<CityBean> getCity(
    Dio _dio,
  ) {
    return Stream.fromFuture(get(_dio, 'api/city/located')).flatMap((value) {
      if (value != null &&
          (value.statusCode >= 200 && value.statusCode < 300)) {
        return Stream.fromFuture(compute(parseCityBean, value.toString()));
      } else {
        throw Exception("--未知网络错误--");
      }
    });
  }

  ///==================base method==================

  Future<Response> get(Dio _dio, url, {data, options, cancelToken}) async {
    Response response;
    try {
      response = await _dio.get(url,
          queryParameters: data, options: options, cancelToken: cancelToken);
      _printHttpLog(response);
    } on DioError catch (e) {
      print('get error---------$e  ${formatError(e)}');
      throw e;
    }
    return response;
  }

  Future<Response> post(Dio _dio, url, {data, options, cancelToken}) async {
    Response response;
    try {
      response = await _dio.post(url,
          data: FormData.fromMap(data),
          options: options,
          cancelToken: cancelToken);
      _printHttpLog(response);
    } on DioError catch (e) {
      print('get error---------$e  ${formatError(e)}');
      throw e;
    }
    return response;
  }

  Future<Response> put(Dio _dio, url, {data, options, cancelToken}) async {
    Response response;
    try {
      response = await _dio.put(url,
          data: FormData.fromMap(data),
          options: options,
          cancelToken: cancelToken);
      _printHttpLog(response);
    } on DioError catch (e) {
      print('get error---------$e  ${formatError(e)}');
      throw e;
    }
    return response;
  }

  Future<Response> delete(Dio _dio, url, {data, options, cancelToken}) async {
    Response response;
    try {
      response = await _dio.delete(url,
          data: FormData.fromMap(data),
          options: options,
          cancelToken: cancelToken);
      _printHttpLog(response);
    } on DioError catch (e) {
      print('get error---------$e  ${formatError(e)}');
      throw e;
    }
    return response;
  }

  Future<Response> upload(Dio _dio, url, String key, String path,
      {Map<String, dynamic> data, options, cancelToken}) async {
    Response response;
    print("UPLOAD===> URL:$url  {$key : $path }   data:$data");
    MultipartFile file = await MultipartFile.fromFile(path,
        filename: path.substring(path.lastIndexOf("/") + 1, path.length));
    if (data == null) {
      data = new Map<String, dynamic>();
    }
    data.putIfAbsent(key, () => file);
    try {
      response = await _dio.post(url,
          data: FormData.fromMap(data),
          options: options,
          cancelToken: cancelToken);
      _printHttpLog(response);
    } on DioError catch (e) {
      print('get error---------$e  ${formatError(e)}');
      throw e;
    }
    return response;
  }

  void _printHttpLog(Response response) {
    if (!inProduction) {
      try {
        printRespond(response);
      } catch (ex) {
        print("Http Log" + " error......");
      }
    }
  }

  static void printRespond(Response response) {
    Map httpLogMap = Map();
    httpLogMap.putIfAbsent("requestMethod", () => "${response.request.method}");
    httpLogMap.putIfAbsent("requestUrl", () => "${response.request.uri}");
    httpLogMap.putIfAbsent("requestHeaders", () => response.request.headers);
    httpLogMap.putIfAbsent(
        "requestQueryParameters", () => response.request.queryParameters);
    if (response.request.data is FormData) {
      httpLogMap.putIfAbsent("requestDataFields",
          () => ((response.request.data as FormData).fields.toString()));
    }
    httpLogMap.putIfAbsent(
        "respondData", () => json.decode(response.toString()));
    printJson(httpLogMap);
  }

  static void printJson(Object object) {
    try {
      var encoderString = encoder.convert(object);
      debugPrint(encoderString);
    } catch (e) {
      print(e);
    }
  }

  String formatError(DioError e) {
    String reason = "";
    if (e.type == DioErrorType.CONNECT_TIMEOUT) {
      reason = "连接超时 ${e.message}";
    } else if (e.type == DioErrorType.SEND_TIMEOUT) {
      reason = "请求超时 ${e.message}";
    } else if (e.type == DioErrorType.RECEIVE_TIMEOUT) {
      reason = "响应超时 ${e.message}";
    } else if (e.type == DioErrorType.RESPONSE) {
      reason = "出现异常 ${e.message}";
    } else if (e.type == DioErrorType.CANCEL) {
      reason = "请求取消 ${e.message}";
    } else {
      reason = "未知错误 ${e.message}";
    }
    return reason;
  }
}

TestBean parseTestBean(String value) {
  return TestBean.fromJson(json.decode(value));
}

CityBean parseCityBean(String value) {
  return CityBean.fromJson(json.decode(value));
}
