/*
 * @author lsy
 * @date   2020/7/1
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:gm_flutter/ClueModel/page/plan/PlanProgressBar.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/eventbus/SimpleEventBus.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';

class FilterView extends StatefulWidget {
  final Function(int high, int low) call;

  int high;
  int low;

  FilterView(this.call, {this.high, this.low});

  @override
  State<StatefulWidget> createState() => FilterViewState();
}

class FilterViewState extends State<FilterView> {
  LiveData<String> lowLive = new LiveData();
  LiveData<String> highLive = new LiveData();

  Function(String str) func;

  @override
  void initState() {
    func = (str) {
      if (str == "reset") {
        highLive.notifyView("无限");
        lowLive.notifyView("￥0");
        SimpleEventBus.instance().notifyListener("PlanProgressBarState", "");
      }
    };
    SimpleEventBus.instance().resignEvent("FilterViewState", func);
    super.initState();
  }

  @override
  void dispose() {
    SimpleEventBus.instance().unResignEvent("FilterViewState", func);
    lowLive.dispost();
    highLive.dispost();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      color: Colors.white,
      height: 186,
      child: Stack(
        children: <Widget>[
          Positioned(
            bottom: 74.5,
            left: 0,
            child: Container(
              width: MediaQuery.of(context).size.width,
              child: PlanProgressBar(
                widget.low,
                widget.high,
                0,
                20010,
                widget.call,
                lowLive,
                highLive,
                padding: 15,
              ),
            ),
          ),
          Positioned(
            top: 54.5,
            right: 15,
            child: StreamBuilder(
              stream: highLive.stream,
              initialData: highLive.data ??
                  (widget.high >= 19600 ? "无限" : "${widget.high}"),
              builder: (c, data) {
                return baseText("${data.data}", 12, Color(0xff3FB5AF));
              },
            ),
          ),
          Positioned(
            top: 54.5,
            left: 15,
            child: StreamBuilder(
              stream: lowLive.stream,
              initialData: lowLive.data ?? "￥${widget.low}",
              builder: (c, data) {
                return baseText("${data.data}", 12, Color(0xff3FB5AF));
              },
            ),
          ),
          Positioned(
            top: 25,
            left: 15,
            child: baseText("价格区间:", 13, Color(0xff666666)),
          ),
          Positioned(
            bottom: 0,
            child: Container(
              width: MediaQuery.of(context).size.width,
              height: 44.5,
              child: Row(
                children: <Widget>[
                  Expanded(
                    child: Container(
                      child: baseText("重置", 16, Color(0xff3FB5AF)),
                      alignment: Alignment.center,
                    ).gestureDetector(() {
                      SimpleEventBus.instance().notifyListener("FilterViewState", "reset");
                    }),
                  ),
                  Expanded(
                    child: Container(
                      color: Color(0xff3FB5AF),
                      alignment: Alignment.center,
                      child: baseText("确定", 16, Colors.white),
                    ).gestureDetector(() {
                      SimpleEventBus.instance()
                          .notifyListener("PlanProgressBarState", "sure");
                    }),
                  )
                ],
              ),
            ),
          )
        ],
      ),
    );
  }
}
