/*
 * @author lsy
 * @date   2020/7/1
 **/
class PlanBean {
  int error;
  String message;
  Map extra;
  Map errorCode;
  Map errorExtra;
  Data data;
  UserType userType;

  PlanBean({this.error, this.message, this.extra, this.errorCode, this.errorExtra, this.data, this.userType});

  PlanBean.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    errorCode = json['error_code'];
    errorExtra = json['error_extra'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    userType = json['user_type'] != null ? new UserType.fromJson(json['user_type']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    data['error_code'] = this.errorCode;
    data['error_extra'] = this.errorExtra;
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    if (this.userType != null) {
      data['user_type'] = this.userType.toJson();
    }
    return data;
  }
}

class Data {
  List<Ranks> ranks;
  List<Tags> tags;
  Areas areas;
  List<Orders> orders;

  Data({this.ranks, this.tags, this.areas, this.orders});

  Data.fromJson(Map<String, dynamic> json) {
    if (json['ranks'] != null) {
      ranks = new List<Ranks>();
      json['ranks'].forEach((v) { ranks.add(new Ranks.fromJson(v)); });
    }
    if (json['tags'] != null) {
      tags = new List<Tags>();
      json['tags'].forEach((v) { tags.add(new Tags.fromJson(v)); });
    }
    areas = json['areas'] != null ? new Areas.fromJson(json['areas']) : null;
    if (json['orders'] != null) {
      orders = new List<Orders>();
      json['orders'].forEach((v) { orders.add(new Orders.fromJson(v)); });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.ranks != null) {
      data['ranks'] = this.ranks.map((v) => v.toJson()).toList();
    }
    if (this.tags != null) {
      data['tags'] = this.tags.map((v) => v.toJson()).toList();
    }
    if (this.areas != null) {
      data['areas'] = this.areas.toJson();
    }
    if (this.orders != null) {
      data['orders'] = this.orders.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Ranks {
  int id;
  String name;
  String gmUrl;
  String icon;

  Ranks({this.id, this.name, this.gmUrl, this.icon});

  Ranks.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    gmUrl = json['gm_url'];
    icon = json['icon'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    data['gm_url'] = this.gmUrl;
    data['icon'] = this.icon;
    return data;
  }
}

class Tags {
  List<Subtags> subtags;
  int isNewTag;
  String name;
  int tagId;

  Tags({this.subtags, this.isNewTag, this.name, this.tagId});

  Tags.fromJson(Map<String, dynamic> json) {
    if (json['subtags'] != null) {
      subtags = new List<Subtags>();
      json['subtags'].forEach((v) { subtags.add(new Subtags.fromJson(v)); });
    }
    isNewTag = json['is_new_tag'];
    name = json['name'];
    tagId = json['tag_id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.subtags != null) {
      data['subtags'] = this.subtags.map((v) => v.toJson()).toList();
    }
    data['is_new_tag'] = this.isNewTag;
    data['name'] = this.name;
    data['tag_id'] = this.tagId;
    return data;
  }
}

class Subtags {
  int isNewTag;
  String name;
  int tagId;

  Subtags({this.isNewTag, this.name, this.tagId});

  Subtags.fromJson(Map<String, dynamic> json) {
    isNewTag = json['is_new_tag'];
    name = json['name'];
    tagId = json['tag_id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['is_new_tag'] = this.isNewTag;
    data['name'] = this.name;
    data['tag_id'] = this.tagId;
    return data;
  }
}

class Areas {
  AutoLocated autoLocated;
  List<Countries> countries;

  Areas({this.autoLocated, this.countries});

  Areas.fromJson(Map<String, dynamic> json) {
    autoLocated = json['auto_located'] != null ? new AutoLocated.fromJson(json['auto_located']) : null;
    if (json['countries'] != null) {
      countries = new List<Countries>();
      json['countries'].forEach((v) { countries.add(new Countries.fromJson(v)); });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.autoLocated != null) {
      data['auto_located'] = this.autoLocated.toJson();
    }
    if (this.countries != null) {
      data['countries'] = this.countries.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class AutoLocated {
  int type;
  int id;
  String name;

  AutoLocated({this.type, this.id, this.name});

  AutoLocated.fromJson(Map<String, dynamic> json) {
    type = json['type'];
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['type'] = this.type;
    data['id'] = this.id;
    data['name'] = this.name;
    return data;
  }
}

class Countries {
  bool isLocated;
  String name;
  List<Groups> groups;

  Countries({this.isLocated, this.name, this.groups});

  Countries.fromJson(Map<String, dynamic> json) {
    isLocated = json['is_located'];
    name = json['name'];
    if (json['groups'] != null) {
      groups = new List<Groups>();
      json['groups'].forEach((v) { groups.add(new Groups.fromJson(v)); });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['is_located'] = this.isLocated;
    data['name'] = this.name;
    if (this.groups != null) {
      data['groups'] = this.groups.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Groups {
  bool isHot;
  String initial;
  List<Cities> cities;
  String title;

  Groups({this.isHot, this.initial, this.cities, this.title});

  Groups.fromJson(Map<String, dynamic> json) {
    isHot = json['is_hot'];
    initial = json['initial'];
    if (json['cities'] != null) {
      cities = new List<Cities>();
      json['cities'].forEach((v) { cities.add(new Cities.fromJson(v)); });
    }
    title = json['title'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['is_hot'] = this.isHot;
    data['initial'] = this.initial;
    if (this.cities != null) {
      data['cities'] = this.cities.map((v) => v.toJson()).toList();
    }
    data['title'] = this.title;
    return data;
  }
}

class Cities {
  String id;
  String name;
  int tagId;

  Cities({this.id, this.name, this.tagId});

  Cities.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    tagId = json['tag_id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    data['tag_id'] = this.tagId;
    return data;
  }
}

class Orders {
  int id;
  String name;

  Orders({this.id, this.name});

  Orders.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    return data;
  }
}

class UserType {


  UserType();

UserType.fromJson(Map<String, dynamic> json) {
}

Map<String, dynamic> toJson() {
  final Map<String, dynamic> data = new Map<String, dynamic>();
  return data;
}
}

