/*
 * @author zcc
 * @date   2020-07-01
 * 项目说明
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/server/entity/ProjectDetailsItem.dart';

class ProjectDetailsItemView extends StatelessWidget {
  Groups listData;
  List<Widget> listAttrs = [];

  ProjectDetailsItemView(this.listData) {
    init();
  }

  init() {
    for (var item in listData.attrs) {
      listAttrs.add(getAttrItem(item));
    }
  }

  @override
  Widget build(BuildContext context) {
    return Column(
      children: <Widget>[
        Container(
            padding: EdgeInsets.only(left: 15.0),
            margin: EdgeInsets.only(bottom: 16.0),
            alignment: Alignment.centerLeft,
            height: 55,
            decoration: BoxDecoration(
                image: DecorationImage(
                    image: AssetImage("assets/bg_project_detail_item.png"),
                    fit: BoxFit.cover)),
            child: baseText(listData.name, 15, Colors.black, bold: true)),
        Column(
          children: listAttrs,
        ),
        SizedBox(
          height: 5,
        )
      ],
    );
  }

  getAttrItem(Attrs attrs) {
    return Container(
      width: double.maxFinite,
      margin: EdgeInsets.only(bottom: 25, left: 15, right: 15),
      child: Row(
        children: <Widget>[
          Container(
            margin: EdgeInsets.only(right: 25.0),
            alignment: Alignment.centerLeft,
            width: 78,
            child: baseText(attrs.attrName, 13, Color(0xFF999999)),
          ),
          Container(
              alignment: Alignment.centerLeft,
              child: baseText(attrs.attrValue, 14, Color(0xFF282828))),
        ],
      ),
    );
  }

  baseText(String text, double fontSize, Color color, {bool bold = false}) {
    return Text(
      text,
      textScaleFactor: 1.0,
      style: TextStyle(
          decoration: TextDecoration.none,
          fontSize: fontSize,
          color: color,
          fontStyle: FontStyle.normal,
          fontWeight: bold ? FontWeight.w500 : FontWeight.w400),
      maxLines: 2,
      overflow: TextOverflow.ellipsis,
    );
  }
}
