/*
 * @author lsy
 * @date   2020/5/14
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:flutter_common/commonModel/toast/toast.dart';
import 'package:gm_flutter/MainRouter/service/remote/api/MainApi.serv.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';
import 'package:gm_flutter/commonModel/net/DioUtil.dart';

import '../../../main.mark.dart';

class NetProxyPage extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => NetProxyState();
}

class NetProxyState extends BaseState<NetProxyPage> {
  TextEditingController _editingController = TextEditingController();

  @override
  Widget buildItem(BuildContext context) {
    return Scaffold(
      appBar: baseAppBar(
          centerTitle: true,
          backClick: () {
            if(RouterCenterImpl().findMainRouter().isWithNative()){
              FlutterBoost.singleton.closeCurrent();
            }else{
              Navigator.of(context).pop();
            }
          },
          title: "设置代理页面"),
      body: Column(
        children: <Widget>[
          Container(
            height: 30,
          ),
          Container(
            height: 30,
            child: baseTextField(_editingController, TextInputType.text,
                "请您输入代理网址 例如:172.9.30.10"),
          ),
          Expanded(
            child: Container(),
          ),
          InkWell(
              onTap: () {
                MainApiImpl.getInstance()
                    .isOk(DioUtil.getInstance().getDio())
                    .listen((event) {}).onError((error){
                      print("LSYQQ ${error.toString()}");
                });
              },
              child: Container(
                margin: EdgeInsets.only(bottom: 30, left: 15, right: 15),
                height: 30,
                color: Colors.blue,
                width: double.maxFinite,
                alignment: Alignment.center,
                child: baseText("测试代理调用接口", 15, Colors.white),
              )),
          InkWell(
              onTap: () {
                if (_editingController.text == null) {
                  Toast.show(context, "请输入代理");
                  return;
                }
                DioUtil().setProxy(_editingController.text);
                Toast.show(context, "设置成功");
              },
              child: Container(
                margin: EdgeInsets.only(bottom: 30, left: 15, right: 15),
                height: 30,
                color: Colors.blue,
                alignment: Alignment.center,
                width: double.maxFinite,
                child: baseText("设置代理", 15, Colors.white),
              ))
        ],
      ),
    );
  }

  @override
  void dispose() {
    _editingController.dispose();
    super.dispose();
  }
}
