import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlansCompareFeed.dart';

class PlansCompareFeedItemView extends StatelessWidget {
  Plans plan;
  int groupValue = 1;

  PlansCompareFeedItemView(this.plan);

  @override
  Widget build(BuildContext context) {
    return Container(child: getItem());
  }

  getItem() {
    if (plan.planType == 1) {
      return getFirstLevelItem();
    } else {
      return getSecondLevelItem();
    }
  }

  getFirstLevelItem() {
    Container(
      margin: EdgeInsets.all(4.0),
      child: Row(
        children: <Widget>[
          Radio(
              value: 1,
              groupValue: groupValue,
              onChanged: (value) {
                groupValue = value;
              }),
          ClipRRect(
            borderRadius: BorderRadius.circular(2.0),
            child: Image.network(
              plan.projectImage,
              width: 50,
              height: 50,
              fit: BoxFit.fill,
            ),
          ),
          Expanded(
              child: Container(
            margin: EdgeInsets.only(left: 8.0),
            height: 50,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Row(
                  children: <Widget>[
                    Text(
                      plan.name,
                      style: TextStyle(
                          fontWeight: FontWeight.bold,
                          fontSize: 14,
                          color: Color(0xFF282828)),
                      maxLines: 1,
                    ),
                    Text(
                      "好评率 ",
                      style: TextStyle(fontSize: 11, color: Color(0xFF282828)),
                      maxLines: 1,
                    ),
                    Text(
                      plan.positiveRate,
                      style: TextStyle(
                          fontWeight: FontWeight.bold,
                          fontSize: 14,
                          color: Color(0xFFFF5963)),
                      maxLines: 1,
                    ),
                  ],
                ),
                Row(
                  children: <Widget>[
                    Text(
                      '￥${plan.minPrice}-${plan.maxPrice})',
                      style: TextStyle(fontSize: 13, color: Color(0xFFFF5963)),
                    ),
                    Text(
                      "销量${plan.salesCount}",
                      style: TextStyle(fontSize: 11, color: Color(0xFF282828)),
                      maxLines: 1,
                    )
                  ],
                )
              ],
            ),
          ))
        ],
      ),
    );
  }

  getSecondLevelItem() {
    Container(
      margin: EdgeInsets.all(4.0),
      child: Row(
        children: <Widget>[
          Radio(
              value: 1,
              groupValue: groupValue,
              onChanged: (value) {
                groupValue = value;
              }),
          Expanded(
              child: Container(
            margin: EdgeInsets.only(left: 8.0),
            height: 50,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Text(
                  plan.name,
                  style: TextStyle(
                      fontWeight: FontWeight.bold,
                      fontSize: 14,
                      color: Color(0xFF282828)),
                  maxLines: 1,
                ),
                Row(
                  children: <Widget>[
                    Text(
                      '￥${plan.minPrice}-${plan.maxPrice})',
                      style: TextStyle(fontSize: 13, color: Color(0xFFFF5963)),
                    ),
                    Text(
                      "指导价：￥${plan.guidePrice}",
                      style: TextStyle(fontSize: 11, color: Color(0xFF282828)),
                      maxLines: 1,
                    )
                  ],
                )
              ],
            ),
          ))
        ],
      ),
    );
  }
}
