import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlansCompareFeed.dart';
import 'package:gm_flutter/commonModel/net/DioUtil.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';

class PlansCompareFeedModel extends BaseModel {
  LiveData<PlansCompareFeed> liveData = LiveData();
  RxDispose rxDispose = RxDispose();

  void init() {
    ClueApiImpl.getInstance()
        .getPlansCompareFeed(DioUtil.getInstance().getDio(), 123, 1)
        .listen((event) {
          if (event.error == 0) {
            liveData.notifyView(event);
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {});
  }

  @override
  void dispose() {
    liveData.dispost();
    rxDispose.dispose();
  }
}
