/*
 * @author zcc
 * @date   2020-07-01
 * 方案对比
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/page/PlansCompareFeed/PlansCompareFeedModel.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlansCompareFeed.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';

import 'PlansCompareFeedItemView.dart';

class PlansCompareFeedPage extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => PlansCompareFeedState();
}

class PlansCompareFeedState extends BaseState<PlansCompareFeedPage> {
  PlansCompareFeedModel _model = new PlansCompareFeedModel();

  @override
  void initState() {
    super.initState();
    _model.init();
  }

  @override
  void dispose() {
    _model.dispose();
    super.dispose();
  }

  @override
  Widget buildItem(BuildContext context) {}

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text("方案对比"),
      ),
      body: Center(
        child: getBody(),
      ),
    );
  }

  getList(List<Plans> plans) {
    return Stack(alignment: Alignment.bottomCenter, //指定未定位或部分定位widget的对齐方式
        children: <Widget>[
          ListView.builder(
              itemCount: plans.length,
              itemBuilder: (BuildContext context, int position) {
                return PlansCompareFeedItemView(plans[position]);
              }),
          GestureDetector(
              behavior: HitTestBehavior.opaque,
              onTap: () {},
              child: Container(
                margin:
                    EdgeInsets.only(left: 15, right: 15, top: 7.5, bottom: 7.5),
                width: double.maxFinite,
                height: 40,
                decoration: BoxDecoration(
                    color: Color(0xff51CDC7),
                    borderRadius: BorderRadius.circular(20)),
                alignment: Alignment.center,
                child: baseText("对比", 14, Colors.white, bold: true),
              ))
        ]);
  }

  getBody() {
    return StreamBuilder(
      stream: _model.liveData.stream,
      initialData: PlansCompareFeed(),
      builder: (c, data) {
        PlansCompareFeed item = data.data;
        if (item == null || item.data == null || item.data.plans == null) {
          return loadingItem();
        }
        return getList(item.data.plans);
      },
    );
  }
}
