/*
 * @author zcc
 * @date   2020-07-01
 * 项目说明
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/page/ProjectDetails/ProjectDetailsItemView.dart';
import 'package:gm_flutter/ClueModel/page/ProjectDetails/ProjectDetailsModel.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';

import '../../server/entity/ProjectDetailsItem.dart';

class ProjectDetailsPage extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => ProjectDetailsState();
}

class ProjectDetailsState extends BaseState<ProjectDetailsPage> {
  ProjectDetailsModel _model = new ProjectDetailsModel();

  @override
  void initState() {
    super.initState();
    _model.init();
  }

  @override
  void dispose() {
    _model.dispose();
    super.dispose();
  }

  @override
  Widget buildItem(BuildContext context) {}

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text("项目说明"),
      ),
      body: Center(
        child: getBody(),
      ),
    );
  }

  getBody() {
    return StreamBuilder(
      stream: _model.liveData.stream,
      initialData: ProjectDetailsItem(),
      builder: (c, data) {
        ProjectDetailsItem item = data.data;
        if (item == null || item.data == null || item.data.groups == null) {
          return loadingItem();
        }
        return ListView.builder(
            itemCount: item.data.groups.length,
            itemBuilder: (BuildContext context, int position) {
              return ProjectDetailsItemView(item.data.groups[position]);
            });
      },
    );
  }
}
