/*
 * @author lsy
 * @date   2020/5/13
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/util/JumpUtil.dart';
import 'package:gm_flutter/MainRouter/page/proxy/NetProxyPage.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';
import 'package:gm_flutter/main.mark.dart';

import 'TP.dart';

class TestPage extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => TestState();
}

class TestState extends BaseState<TestPage> {
  //Add test here
  List<Widget> innerList() {
    List<Widget> list = new List();
    //在这加入
    list.add(listItem("设置代理页面", () {
      JumpUtil.jumpToPageRight(context, NetProxyPage());
    }));
    list.add(listItem("一级列表页", () {
      JumpUtil.jumpToPageRight(context, RouterCenterImpl().findClueRouter().getLevelOnePage());
    }));
    return list;
  }

  @override
  Widget buildItem(BuildContext context) {
    return Scaffold(
      appBar: baseAppBar(
          title: "测试页面",
          centerTitle: true,
          backClick: () {
            Navigator.pop(context);
          }),
      body: Container(
        child: ListView(
          children: innerList(),
        ),
      ),
    );
  }

  Widget listItem(String text, VoidCallback callback) {
    return GestureDetector(
        onTap: callback,
        child: Container(
          margin: EdgeInsets.only(left: 16, right: 16, top: 8, bottom: 8),
          decoration: BoxDecoration(
              color: Colors.blue, borderRadius: BorderRadius.circular(5.0)),
          width: double.maxFinite,
          height: 60,
          alignment: Alignment.center,
          child: baseText(text, 18, Colors.white),
        ));
  }
}
