/*
 * @author lsy
 * @date   2020/6/29
 **/
import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/server/entity/LevelOneFeedList.dart';
import 'package:gm_flutter/ClueModel/view/FiveStarView.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseUtil.dart';

class LevelOneItem extends StatelessWidget {
  final Cards cards;
  VoidCallback lowPrice;
  VoidCallback ask;

  LevelOneItem(this.cards, {this.lowPrice, this.ask});

  @override
  Widget build(BuildContext context) {
    if (cards.cardType == "plan") {
      return PlanItem(context);
    } else if (cards.cardType == "hospital") {
      return HospitalItem(context);
    } else if (cards.cardType == "doctor") {
      return DoctorItem(context);
    } else if (cards.cardType == "diary") {
      return DiaryItem(context);
    }
  }

  Widget DoctorItem(BuildContext context) {
    if (cards.doctor == null && isDebug) {
      throw new Exception();
    }
    return GestureDetector(
      child: Container(
        margin: EdgeInsets.only(left: 15, right: 15),
        height: 127,
        child: Stack(
          children: <Widget>[
            Positioned(
              top: 15,
              child: Container(
                width: 45,
                height: 45,
                child: ClipOval(
                  child: CachedNetworkImage(
                    imageUrl: cards.doctor.portrait,
                  ),
                ),
              ),
            ),
            Positioned(
              left: 57,
              top: 18,
              child: Row(
                mainAxisSize: MainAxisSize.min,
                crossAxisAlignment: CrossAxisAlignment.end,
                children: <Widget>[
                  baseText(cards.doctor.name, 15, Color(0xff333333),
                      bold: true),
                  Container(
                    margin: EdgeInsets.only(left: 4),
                    child: baseText(cards.doctor.name, 15, Color(0xff333333),
                        bold: true),
                  )
                ],
              ),
            ),
            Positioned(
              top: 42,
              right: 0,
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.end,
                mainAxisSize: MainAxisSize.min,
                children: <Widget>[
                  baseText("¥", 12, Color(0xffFF5963)),
                  baseText("${cards.doctor.minPrice}-${cards.doctor.maxPrice}",
                      15, Color(0xffFF5963)),
                ],
              ),
            ),
            Positioned(
              bottom: 15,
              right: 0,
              child: lowPriceWidget(),
            ),
            Positioned(
              bottom: 15,
              right: 187,
              child: askWidget(),
            ),
            Positioned(
              left: 4.5,
              bottom: 25,
              child: compareWidget(),
            ),
          ],
        ),
      ),
    );
  }

  Widget HospitalItem(BuildContext context) {
    if (cards.hospital == null && isDebug) {
      throw new Exception();
    }
    return GestureDetector(
        onTap: () {},
        child: Container(
          margin: EdgeInsets.only(left: 15, right: 15),
          height: 149,
          child: Stack(
            children: <Widget>[
              Positioned(
                left: 0,
                top: 15,
                child: Container(
                  width: 45,
                  height: 45,
                  child: ClipOval(
                    child: CachedNetworkImage(
                      imageUrl: cards.hospital.portrait,
                    ),
                  ),
                ),
              ),
              Positioned(
                left: 57,
                top: 17.5,
                child: baseText(cards.hospital.name, 15, Color(0xff333333),
                    bold: true),
              ),
              Positioned(
                top: 42.5,
                right: 0,
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.end,
                  mainAxisSize: MainAxisSize.min,
                  children: <Widget>[
                    baseText("¥", 12, Color(0xffFF5963)),
                    baseText(
                        "${cards.hospital.minPrice}-${cards.hospital.maxPrice}",
                        15,
                        Color(0xffFF5963)),
                  ],
                ),
              ),
              Positioned(
                bottom: 15,
                right: 0,
                child: lowPriceWidget(),
              ),
              Positioned(
                bottom: 15,
                right: 187,
                child: askWidget(),
              ),
              Positioned(
                left: 4.5,
                bottom: 25,
                child: compareWidget(),
              ),
              Positioned(
                bottom: 67,
                left: 57,
                child: baseText(cards.hospital.address, 12, Color(0xff666666)),
              ),
              Positioned(
                left: 57,
                top: 43.5,
                child: FiveStarView(int.parse(cards.hospital.star), 5),
              )
            ],
          ),
        ));
  }

  Widget PlanItem(BuildContext context) {
    if (cards.plan == null && isDebug) {
      throw new Exception();
    }
    return Container(
      height: 118,
      margin: EdgeInsets.only(left: 15, right: 15),
      child: Stack(
        children: <Widget>[
          Positioned(
            left: 0,
            top: 15,
            child: baseText(cards.plan.planName, 15, Color(0xff282828),
                bold: true),
          ),
          Positioned(
            right: 0,
            top: 15,
            child: Row(
              mainAxisSize: MainAxisSize.min,
              crossAxisAlignment: CrossAxisAlignment.end,
              children: <Widget>[
                baseText("¥", 12, Color(0xffFF5963)),
                baseText(cards.plan.maxPrice, 15, Color(0xffFF5963))
              ],
            ),
          ),
          Positioned(
            left: 4.5,
            bottom: 25,
            child: compareWidget(),
          ),
          Positioned(bottom: 15, right: 0, child: lowPriceWidget()),
          Positioned(
            right: 152,
            bottom: 15,
            child: askWidget(),
          ),
          Positioned(
            top: 40,
            right: 0,
            child: baseText(
                "指导价：¥${cards.plan.minPrice}-${cards.plan.maxPrice}",
                11,
                Color(0xff666666)),
          ),
          Positioned(
            left: 15,
            bottom: 0,
            child: Container(
              width: MediaQuery.of(context).size.width - 30,
              height: 0.5,
              color: Color(0xffE5E5E5),
            ),
          )
        ],
      ),
    );
  }

  Widget lowPriceWidget() {
    return GestureDetector(
      onTap: lowPrice,
      behavior: HitTestBehavior.opaque,
      child: Container(
        width: 122,
        height: 37,
        decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(18.5),
            color: Color(0xffFFF5F5)),
        alignment: Alignment.center,
        child: baseText("获取底价", 14, Color(0xffFF5963), bold: true),
      ),
    );
  }

  Widget askWidget() {
    return GestureDetector(
      onTap: ask,
      behavior: HitTestBehavior.opaque,
      child: Container(
        width: 122,
        height: 37,
        decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(18.5),
            color: Color(0xffEEFDFD)),
        alignment: Alignment.center,
        child: baseText("咨询", 14, Color(0xff3FB5AF), bold: true),
      ),
    );
  }

  Widget compareWidget() {
    return Row(
      mainAxisSize: MainAxisSize.min,
      crossAxisAlignment: CrossAxisAlignment.center,
      children: <Widget>[
        Container(
          width: 18,
          height: 18,
          child: Image.asset("assets/vs.png"),
        ),
        Container(
          margin: EdgeInsets.only(left: 1.5),
          child: baseText("去比较", 13, Color(0xff282828), bold: true),
        )
      ],
    );
  }

  Widget DiaryItem(BuildContext context) {
    if (cards.plan == null && isDebug) {
      throw new Exception();
    }
    return Container(
      margin: EdgeInsets.only(left: 20, right: 20),
      width: double.maxFinite,
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: <Widget>[
          Container(
            height: 25,
            child: Row(
              mainAxisSize: MainAxisSize.min,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: <Widget>[
                Container(
                  width: 25,
                  height: 25,
                  child: ClipOval(
                    child: CachedNetworkImage(
                      imageUrl: cards.diary.user.portrait,
                      fit: BoxFit.cover,
                    ),
                  ),
                ),
                Container(
                  margin: EdgeInsets.only(left: 8),
                  child: baseText(
                      cards.diary.user.userName, 13, Color(0xff999999)),
                ),
                cards.diary.userLevel!=null&&cards.diary.userLevel.levelIcon!=null
                    ? Container(
                        width: 31,
                        height: 12,
                        child: CachedNetworkImage(
                          imageUrl: cards.diary.userLevel.levelIcon,
                        ),
                      )
                    : Container(
                        width: 0,
                      )
              ],
            ),
          ),
          (cards.diary.images == null ||
                  cards.diary.images.isEmpty ||
                  cards.diary.images.length < 2)
              ? Container(
                  height: 0,
                )
              : Row(
                  children: <Widget>[
                    Expanded(
                      child: Container(
                        decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(4),
                            image: DecorationImage(
                                fit: BoxFit.cover,
                                image: NetworkImage(
                                    cards.diary.images[0].imageHalf))),
                        alignment: Alignment.bottomLeft,
                        child: Container(
                          width: 65.5,
                          height: 18,
                          decoration: BoxDecoration(
                              color: Color(0x4c000000),
                              borderRadius: BorderRadius.only(
                                bottomLeft: Radius.circular(4),
                                topRight: Radius.circular(2),
                              )),
                          alignment: Alignment.center,
                          child: baseText(
                              cards.diary.images[0].desc, 11, Colors.white),
                        ),
                      ),
                    ),
                    Container(
                      width: 9,
                    ),
                    Expanded(
                      child: Container(
                        decoration: BoxDecoration(
                            image: DecorationImage(
                                fit: BoxFit.cover,
                                image: NetworkImage(
                                    cards.diary.images[1].imageHalf))),
                        alignment: Alignment.bottomLeft,
                        child: Container(
                          width: 65.5,
                          height: 18,
                          decoration: BoxDecoration(
                              color: Color(0x4c000000),
                              borderRadius: BorderRadius.only(
                                bottomLeft: Radius.circular(4),
                                topRight: Radius.circular(2),
                              )),
                          alignment: Alignment.center,
                          child: baseText(
                              cards.diary.images[1].desc, 11, Colors.white),
                        ),
                      ),
                    )
                  ],
                ),
          Container(
            margin: EdgeInsets.only(top: 12.5,bottom: 12),
            child:Text(
              cards.diary.content,
              textScaleFactor: 1.0,
              maxLines: 5,
              overflow: TextOverflow.ellipsis,
              style: TextStyle(
                  decoration: TextDecoration.none,
                  fontSize: 15,
                  color: Color(0xff464646),
                  fontStyle: FontStyle.normal,
                  fontWeight: FontWeight.w400),
            ) ,
          )
          ,
          baseText("项目${cards.diary.title}", 13, Color(0xff999999)),
         Container(
           margin: EdgeInsets.only(top: 12,bottom: 16),
           height: 14,
           child: Row(
             mainAxisSize: MainAxisSize.min,
             crossAxisAlignment: CrossAxisAlignment.center,
             children: <Widget>[
               Container(
                 width: 14,
                 height: 14,
                 child: Image.asset("assets/eye.png"),
               ),
               Container(
                 margin: EdgeInsets.only(left: 5,right: 20),
                 child: baseText("${cards.diary.viewNum}", 12, Color(0xff999999)),
               ),
               Container(
                 width: 14,
                 height: 14,
                 child: Image.asset("assets/arguement.png"),
               ),
               Container(
                 margin: EdgeInsets.only(left: 5,right: 20),
                 child: baseText("${cards.diary.replyNum}", 12, Color(0xff999999)),
               ),
               Container(
                 width: 14,
                 height: 14,
                 child: Image.asset("assets/heart.png"),
               ),
               Container(
                 margin: EdgeInsets.only(left: 5,right: 20),
                 child: baseText("${cards.diary.voteNum}", 12, Color(0xff999999)),
               )
             ],
           ),
         ),
          Container(
            width: double.maxFinite,
            height: 0.5,
            color: Color(0xffE5E5E5),
          )
        ],
      ),
    );
  }
}
