/*
 * @author lsy
 * @date   2020/6/30
 **/
import 'dart:convert';

import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanBean.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanFeedBean.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/cache/CacheManager.dart';
import 'package:gm_flutter/commonModel/eventbus/SimpleEventBus.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:gm_flutter/commonModel/util/PrintUtil.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class PlanModel extends BaseModel {
  final String PLAN_MODEL_BUFFER = "PLAN_MODEL_BUFFER";
  final String PLAN_MODEL_LIST_BUFFER = "PLAN_MODEL_LIST_BUFFER";
  LiveData<List> managerLive = new LiveData();
  LiveData<List<double>> posLive = new LiveData();
  LiveData<List<double>> backLive = new LiveData();
  LiveData<List<Ranks>> picLive = LiveData();
  LiveData<bool> showTab = LiveData();
  LiveData<int> stateLive = LiveData();

  double menuBottom;
  int menuIndex = -1;
  bool needChangBack = true;
  LiveData<Pair<int, List<Plans>>> feedsLive = LiveData();
  List<Plans> feedDatas = [];

  List<Tags> projectData = [];
  List<Orders> sortList = [];
  RxDispose rxDispose = RxDispose();

  String tag_id = "0";
  String order_by = "";
  String current_city_id = "";
  String min_price = "0";
  String max_price = "100000000";
  String rank_type = "";

  List<String> normalData = ["全部项目", "智能筛选", "筛选"];

  int page = 1;
  int sortPos = 0;

  void init({VoidCallback call, bool needCache = false}) {
    print("LSY PLANMODEL IIIIIINT ");
    if (CacheManager.getInstance().get(MEMORY_CACHE).get(PLAN_MODEL_BUFFER) !=
            null &&
        needCache) {
      var event = PlanBean.fromJson(json.decode(
          CacheManager.getInstance().get(MEMORY_CACHE).get(PLAN_MODEL_BUFFER)));
      projectData = event.data.tags;
      sortList = event.data.orders;
      picLive.notifyView(event.data.ranks);
      stateLive.notifyView(ENDLOADING);
      normalData[1] = event.data.orders[0].name;
      managerLive.notifyView(normalData);
      if (call != null) {
        call();
      }
      refreshFeed(true, needCache: needCache);
      return;
    }
    ClueApiImpl.getInstance()
        .getPlan(DioUtil.getInstance().getDio())
        .listen((event) {
          if (event.error == 0) {
            projectData = event.data.tags;
            sortList = event.data.orders;
            picLive.notifyView(event.data.ranks);
            stateLive.notifyView(ENDLOADING);
            normalData[1] = event.data.orders[0].name;
            managerLive.notifyView(normalData);
            if (call != null) {
              call();
            }
            refreshFeed(true, needCache: needCache);
            CacheManager.getInstance()
                .get(MEMORY_CACHE)
                .save(PLAN_MODEL_BUFFER, json.encode(event.toJson()));
          } else {
            stateLive.notifyView(FAIL);
            NativeToast.showNativeToast(event.message);
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          print("ERROR12WCCCCCC  ${err.toString()}");
          PrintUtil.printBug(err);
          stateLive.notifyView(FAIL);
        });
  }

  void projectClick(String id, String name) {
    if (tag_id == id) {
      return;
    }
    normalData[0] = name;
    managerLive.notifyView(normalData);
    tag_id = id;
    feedsLive.notifyView(Pair(LOADING, null));
    refreshFeed(true);
  }

  void refreshFeed(bool clear,
      {RefreshController controller, bool needCache = false}) {
    if (clear) {
      page = 1;
      feedDatas.clear();
    }
    if (needCache
    &&CacheManager.getInstance().get(MEMORY_CACHE).get(PLAN_MODEL_LIST_BUFFER)!=null) {
      var event = PlanFeedBean.fromJson(json.decode(
          CacheManager.getInstance().get(MEMORY_CACHE).get(PLAN_MODEL_LIST_BUFFER)));
      if (event.data.plans == null || event.data.plans.isEmpty) {
        if (page == 1) {
          feedsLive.notifyView(Pair(EMPTY, []));
        } else {
          feedsLive.notifyView(Pair(ENDLOADING, []));
        }
      } else {
        feedDatas.addAll(event.data.plans);
        feedsLive.notifyView(Pair(ENDLOADING, feedDatas));
      }
      WidgetsBinding.instance.addPostFrameCallback((_) {
        SimpleEventBus.instance()
            .notifyListener("BaseNestedScrollViewRefreshIndicator", "refresh");
      });
    }
    ClueApiImpl.getInstance()
        .getPlanFeed(DioUtil.getInstance().getDio(), tag_id, order_by,
            current_city_id, min_price, max_price, rank_type, page)
        .listen((event) {
          if (event.error == 0) {
            if (event.data.plans == null || event.data.plans.isEmpty) {
              if (page == 1) {
                feedsLive.notifyView(Pair(EMPTY, []));
              } else {
                feedsLive.notifyView(Pair(ENDLOADING, []));
              }
            } else {
              feedDatas.addAll(event.data.plans);
              feedsLive.notifyView(Pair(ENDLOADING, feedDatas));
              event.data.plans=feedDatas;
              CacheManager.getInstance()
                  .get(MEMORY_CACHE)
                  .save(PLAN_MODEL_LIST_BUFFER, json.encode(event.toJson()));
            }
            controller?.refreshCompleted();
          } else {
            NativeToast.showNativeToast(event.message);
            feedsLive.notifyView(Pair(FAIL, null));
            controller?.refreshFailed();
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          PrintUtil.printBug(err);
          print("PLANERROR ${err}");
          feedsLive.notifyView(Pair(FAIL, null));
          controller?.refreshFailed();
        });
  }

  @override
  void dispose() {
    stateLive.dispost();
    picLive.dispost();
    rxDispose.dispose();
    managerLive.dispost();
    posLive.dispost();
    backLive.dispost();
    feedsLive.dispost();
    showTab.dispost();
  }

  void backProgress(double pro, int index) {
    if (needChangBack || menuIndex == -1) {
      backLive.notifyView([0.0, menuBottom, pro]);
    }
  }

  void loadMore() {
    page++;
    refreshFeed(false);
  }

  void sortClick(int index) {
    if (index == sortPos) {
      return;
    }
    sortPos = index;
    order_by = sortList[index].id.toString();
    normalData[1] = "${sortList[index].name}";
    managerLive.notifyView(normalData);
    feedsLive.notifyView(Pair(LOADING, null));
    refreshFeed(true);
  }

  void filterClick(int max, int min) {
    if (max_price == "${max}" && min_price == "${min}") {
      return;
    }
    if (max > 20000) {
      max = 20000000;
    }
    max_price = "${max}";
    min_price = "${min}";
    feedsLive.notifyView(Pair(LOADING, null));
    refreshFeed(true);
  }
}
