/*
 * @author lsy
 * @date   2020/5/13
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/util/JumpUtil.dart';
import 'package:gm_flutter/MainRouter/page/proxy/NetProxyPage.dart';
import 'package:gm_flutter/commonModel/App.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';
import 'package:gm_flutter/commonModel/cache/CacheManager.dart';
import 'package:gm_flutter/main.mark.dart';
import 'package:gm_flutter/ClueModel/page/DiscussLowPrice/DiscussLowPricePopView.dart';

class TestPage extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => TestState();
}

class TestState extends BaseState<TestPage> {
  //Add test here
  List<Widget> innerList() {
    List<Widget> list = new List();
    //在这加入
    list.add(listItem("设置代理页面", () {
      JumpUtil.jumpToPageRight(context, NetProxyPage());
    }));

    list.add(listItem("一级列表页", () {
      RouterCenterImpl()
          .findMainRouter()
          .jumpPage(context, "level_one_plan_detail", {"planId": 137}, false);
    }));
    list.add(listItem("二级列表页", () {
      RouterCenterImpl()
          .findMainRouter()
          .jumpPage(context, "level_two_plan_deatil", {"planId": 192}, false);
    }));
    list.add(listItem("项目首页", () {
      RouterCenterImpl()
          .findMainRouter()
          .jumpPage(context, "plan_home", {}, false);
    }));
    list.add(listItem("方案页面", () {
      RouterCenterImpl()
          .findMainRouter()
          .jumpPage(context, "plan_home", {"planId": 137}, false);
    }));
    list.add(listItem("对比详情页", () {
      RouterCenterImpl().findMainRouter().jumpPage(
          context,
          "level_one_plan_compare_detail",
          {
            "planIds": [137, 139]
          },
          false);
    }));

    list.add(listItem("方案对比", () {
      JumpUtil.jumpToPageRight(
          context,
          RouterCenterImpl()
              .findClueRouter()
              .getPlansCompareFeed({"planId": 1, "planType": 1}));
    }));
    list.add(listItem("榜单", () {
      JumpUtil.jumpToPageRight(context,
          RouterCenterImpl().findClueRouter().getTopPage({"rank_type": "0"}));
    }));
    list.add(listItem("弹窗", () {
      DiscussLowPricePopView.showPopView(context, "hahaha", "1", "", "112");
    }));
    return list;
  }

  @override
  Widget buildItem(BuildContext context) {
    CacheManager.getInstance().get(MEMORY_CACHE).save(COOKIE,
        "_gm_token=1da6071594101423; csrftoken=rUrkkYYMOVZfIIQnU2IH09QIGmsfe8tE; sessionid=uz7f70uap76r6og48znci5l2hbr9vm5c; _gtid=5af9a5deba8511ea8d4082a085c393c93393");
    return Scaffold(
      appBar: baseAppBar(
          title: "测试页面",
          centerTitle: true,
          backClick: () {
            Navigator.pop(context);
          }),
      body: Container(
        child: ListView(
          children: innerList(),
        ),
      ),
    );
  }

  Widget listItem(String text, VoidCallback callback) {
    return GestureDetector(
        onTap: callback,
        child: Container(
          margin: EdgeInsets.only(left: 16, right: 16, top: 8, bottom: 8),
          decoration: BoxDecoration(
              color: Colors.blue, borderRadius: BorderRadius.circular(5.0)),
          width: double.maxFinite,
          height: 60,
          alignment: Alignment.center,
          child: baseText(text, 18, Colors.white),
        ));
  }
}
