/*
 * @author lsy
 * @date   2020/7/1
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/eventbus/SimpleEventBus.dart';

class PlanProgressBar extends StatefulWidget {
  int low;
  int high;
  int maxlow;
  int maxHigh;
  int padding;
  LiveData<String> lowLive;

  LiveData<String> highLive;

  final Function(int high, int low) call;

  PlanProgressBar(this.low, this.high, this.maxlow, this.maxHigh, this.call,
      this.lowLive, this.highLive,
      {this.padding});

  @override
  State<StatefulWidget> createState() => PlanProgressBarState();
}

class PlanProgressBarState extends State<PlanProgressBar> {
  double distance;
  double leftStarPosPercent;
  double leftPosTempPercent;

  double rightStarPosPercent;
  double rightPosTempPercent;
  double leftDowPos;
  double rightDowPos;

  double scrollDistance;

  double textLeft = -1;
  bool isLeftMove = true;
  Function(String str) func;

  int low;
  int high;

  @override
  void initState() {
    low = widget.low;
    high = widget.high;
    super.initState();
    distance = widget.maxHigh - widget.maxlow - 0.0;
    init();
    func = (str) {
      if (str == "sure") {
        widget.call(high, low);
      } else {
        low = 0;
        high = 20100;
        widget.low = 0;
        widget.high = 20100;
        init();
        setState(() {});
      }
    };
    SimpleEventBus.instance().resignEvent("PlanProgressBarState", func);
  }

  void init() {
    leftStarPosPercent = (widget.low / distance);
    leftPosTempPercent = leftStarPosPercent;

    rightStarPosPercent =
        (widget.high / distance) > 0.03 ? (widget.high / distance) - 0.03 : 0.0;
    rightPosTempPercent = rightStarPosPercent;
  }

  @override
  void dispose() {
    SimpleEventBus.instance().unResignEvent("PlanProgressBarState", func);
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    double totle = MediaQuery.of(context).size.width - widget.padding * 2;
    scrollDistance = 0.03;
    int textInt = (widget.maxlow +
            (isLeftMove ? leftPosTempPercent : rightPosTempPercent + 0.03) *
                distance)
        .toInt();
    if (isLeftMove) {
      low = textInt;
    } else {
      high = textInt;
    }

    String textStr = "￥${textInt}";
    if (textInt > 20000) {
      textStr = "无限";
    }
    if (isLeftMove) {
      widget.lowLive.notifyView(textStr);
    } else {
      widget.highLive.notifyView(textStr);
    }

    double textWidth =13+ (textStr.length-1) * 6.0+21;
    if (textStr == "无限") {
      textWidth = textStr.length * 14.0+12;
    }
    double textL = textLeft * totle - textWidth / 2 + 9;

//    if (textL < 0) {
//      textL = 0;
//    } else if (textL + textWidth > totle) {
//      textL = totle - textWidth;
//    }
    return Container(
      width: double.maxFinite,
      height: 65,
      child: Stack(
        children: <Widget>[
          Positioned(
            bottom: 7.5,
            left: 15,
            child: Container(
              width: totle,
              height: 4,
              decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(50),
                  color: Color(0xffD5D5D5)),
            ),
          ),
          Positioned(
            left: leftPosTempPercent * totle + 5 + 15,
            bottom: 7.5,
            child: Container(
              height: 4,
              width: (rightPosTempPercent - leftPosTempPercent) * totle,
              color: Color(0xff51CDC7),
            ),
          ),
          Positioned(
            left: textL + 11,
            bottom: 23,
            child: Visibility(
              visible: true,
//              textLeft >= 0
              child: Container(
                width: textWidth,
                height: 37,
                child: Stack(
                  alignment: AlignmentDirectional.topCenter,
                  children: <Widget>[
                    Container(
                      width: textWidth,
                      height: 32,
                      color: Colors.white,
                      child: Container(
                        decoration: BoxDecoration(
                          color: Color(0x99000000),
                          borderRadius: BorderRadius.circular(6),
                        ),
                      ),
                    ),
                    Positioned(
                      top: 31.9,
                      child: Container(
                        width: 9,
                        height: 5,
                        child: CustomPaint(
                          painter: TrianglePainter(Color(0x99000000)),
                        ),
                      ),
                    ),
                    Positioned(
                      top: 6,
                      child: Container(
                        width: textWidth,
                        alignment: Alignment.topCenter,
                        child: baseText(textStr, 13, Colors.white),
                      ),
                    )
                  ],
                ),
              ),
            ),
          ),
          Positioned(
              bottom: 0,
              left: leftPosTempPercent * totle + 11,
              child: Listener(
                onPointerDown: (p) {
                  leftDowPos = p.localPosition.dx;
                  isLeftMove = true;
                },
                onPointerMove: (p) {
                  var d = p.localPosition.dx - leftDowPos;
                  leftPosTempPercent = leftStarPosPercent + (d / totle);
                  if (leftPosTempPercent < 0.0) {
                    leftPosTempPercent = 0;
                  } else if (leftPosTempPercent >
                      rightPosTempPercent - scrollDistance) {
                    leftPosTempPercent = rightPosTempPercent - scrollDistance;
                  }
                  textLeft = leftPosTempPercent;
                  setState(() {});
                },
                onPointerUp: (p) {
                  textLeft = -1;
                  leftStarPosPercent = leftPosTempPercent;
                  setState(() {});
                },
                onPointerCancel: (p){
                  textLeft = -1;
                  leftStarPosPercent = leftPosTempPercent;
                  setState(() {});
                },
                child: Container(
                  width: 19,
                  height: 19,
                  alignment: Alignment.centerLeft,
                  child: Image.asset(
                    "assets/progress_inner.png",
                  ),
                ),
              )),
          Positioned(
              bottom: 0,
              left: rightPosTempPercent * totle + 11,
              child: Listener(
                onPointerDown: (p) {
                  rightDowPos = p.localPosition.dx;
                  isLeftMove = false;
                },
                onPointerMove: (p) {
                  var d = p.localPosition.dx - rightDowPos;
                  rightPosTempPercent = rightStarPosPercent + (d / totle);
                  if (rightPosTempPercent <
                      leftPosTempPercent + scrollDistance) {
                    rightPosTempPercent = leftPosTempPercent + scrollDistance;
                  } else if (rightPosTempPercent > 1.0 - 0.03) {
                    rightPosTempPercent = 1.0 - 0.03;
                  }
                  textLeft = rightPosTempPercent;
                  setState(() {});
                },
                onPointerUp: (p) {
                  textLeft = -1;
                  rightStarPosPercent = rightPosTempPercent;
                  setState(() {});
                },
                onPointerCancel: (p){
                  textLeft = -1;
                  rightStarPosPercent = rightPosTempPercent;
                  setState(() {});
                },
                child: Container(
                  width: 19,
                  height: 19,
                  alignment: Alignment.centerLeft,
                  child: Image.asset(
                    "assets/progress_inner.png",
                  ),
                ),
              )),
        ],
      ),
    );
  }
}

class TrianglePainter extends CustomPainter {
  Color color; //填充颜色
  Paint _paint; //画笔
  Path _path; //绘制路径
  double angle; //角度

  TrianglePainter(this.color) {
    _paint = Paint()
      ..color = color
      ..isAntiAlias = true;
    _path = Path();
  }

  @override
  void paint(Canvas canvas, Size size) {
    final baseX = size.width;
    final baseY = size.height;
    _path.moveTo(0, 0);
    _path.lineTo(baseX / 2, baseY);
    _path.lineTo(baseX, 0);
    canvas.drawPath(_path, _paint);
  }

  @override
  bool shouldRepaint(CustomPainter oldDelegate) {
    return false;
  }
}
