/*
 * @author lsy
 * @date   2020/6/29
 **/
import 'dart:async';
import 'dart:math';
import 'dart:ui';

import 'package:extended_nested_scroll_view/extended_nested_scroll_view.dart'
    as extend;
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/page/common/StickyTabBarDelegate.dart';
import 'package:gm_flutter/ClueModel/page/levelOne/LevelOneList.dart';
import 'package:gm_flutter/ClueModel/page/levelOne/LevelOneModel.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';
import 'package:gm_flutter/commonModel/eventbus/SimpleEventBus.dart';
import 'package:gm_flutter/commonModel/view/baseRefreshIndicator.dart';
import 'package:gm_flutter/main.mark.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class LevelOnePage extends StatefulWidget {
  int planId = 10;
  Map<String, dynamic> params;

  LevelOnePage(this.params) {
    this.planId = params["planId"];
  }

  @override
  State<StatefulWidget> createState() => LevelOneState();
}

class LevelOneState extends BaseState<LevelOnePage>
    with TickerProviderStateMixin {
  LevelOneModel _model = new LevelOneModel();
  RefreshController _refreshController = RefreshController();
  GlobalKey keyTop = new GlobalKey();
  GlobalKey key1 = new GlobalKey();
  double screenWidth;
  List<Widget> oneList = new List();
  int lastPageIndex = 0;

  TabController tabController;

  int index = 0;

  @override
  void initState() {
    super.initState();
    _model.plan_id = widget.planId;
    _model.init(() {
      _initTabBar();
    });
  }

  void _initTabBar() {
    if (tabController != null) {
      tabController.removeListener(tabControlerListener);
    }
    tabController = TabController(
        initialIndex: index, length: _model.tabsList.length, vsync: this);
    tabController.addListener(tabControlerListener);
    setState(() {});
  }

  @override
  void dispose() {
    tabController?.removeListener(tabControlerListener);
    tabController?.dispose();
    _model.dispose();
    _refreshController.dispose();
    super.dispose();
  }

  void tabControlerListener() {
    if (index != tabController.index) {
      index = tabController.index;
    }
  }

  @override
  Widget buildItem(BuildContext context) {
    oneList.clear();
    oneList.add(good());
    oneList.add(rect());
    oneList.add(explain());
    oneList.add(Container(
      height: 5,
      color: Color(0xffF7F6FA),
    ));
    screenWidth = MediaQuery.of(context).size.width;
    return Scaffold(
        backgroundColor: Colors.white,
        body: SafeArea(
            top: false,
            child: baseStateView(
                MediaQuery.of(context).size.width,
                MediaQuery.of(context).size.height,
                _model.stateLive,
                Container(
                  child: BaseNestedScrollViewRefreshIndicator(
                      onRefresh: () async {
                        Completer completer = new Completer();
                        _model.init(() {
                          _initTabBar();
                          SimpleEventBus.instance()
                              .notifyListener("LevelOneList", "");
                          completer.complete();
                        });
                        return completer.future;
                      },
                      child: newHomeWarp()),
                ), () {
              _model.init(() {
                _initTabBar();
              });
            })));
  }

  Widget newHomeWarp() {
    return Stack(
      children: <Widget>[
        Container(
            width: MediaQuery.of(context).size.width,
            height: MediaQuery.of(context).size.height,
            child: NotificationListener(
              onNotification: (scrollNotification) {
                if (scrollNotification is KeepAliveNotification ||
                    scrollNotification is OverscrollIndicatorNotification) {
                  return false;
                }
                if (scrollNotification is ScrollUpdateNotification &&
                    scrollNotification.metrics.axisDirection.index == 2) {}
                if (scrollNotification.depth == 0) {
                  if (scrollNotification.metrics.pixels > 80) {
                    _model.textLive.notifyView(
                        (scrollNotification.metrics.pixels - 80) / 40 > 1.0
                            ? 1.0
                            : (scrollNotification.metrics.pixels - 80) / 40);
                  } else {
                    _model.textLive.notifyView(0.0);
                  }
                } else if (scrollNotification.depth == 2) {
                  if (scrollNotification.metrics.pixels < 50 &&
                      scrollNotification.metrics.pixels > 0) {
                    _model.textLive.notifyView(1.0);
                  }
                }
                return false;
              },
              child: newHome(),
            )),
        baseSliverTitle(
            "title", MediaQuery.of(context).size.width, _model.textLive),
        baseSliverBack(() {
          Navigator.of(context).pop();
        }),
      ],
    );
  }

  Widget newHome() {
    List<Widget> list = [];
    var d = MediaQueryData.fromWindow(window).padding.top;
    for (int i = 0; i < _model.tabsList.length; i++) {
      list.add(extend.NestedScrollViewInnerScrollPositionKeyWidget(
          Key("Tab${i}"),
          LevelOneList(
              widget.planId, _model.tabsList[i].tabType, kToolbarHeight + d)));
    }
    final double statusBarHeight = MediaQuery.of(context).padding.top;
    final double pinnedHeaderHeight = statusBarHeight + kToolbarHeight;
    return extend.NestedScrollView(
        innerScrollPositionKeyBuilder: () {
          String index = 'Tab${tabController.index.toString()}';
          return Key(index);
        },
        headerSliverBuilder: (BuildContext context, bool innerBoxIsScrolled) {
          return <Widget>[
            SliverOverlapAbsorber(
                handle: extend.NestedScrollView.sliverOverlapAbsorberHandleFor(
                    context),
                sliver: baseSliverAppBar(
//                        _model.imageUrl
                    "https://pic.igengmei.com/2018/09/11/1513/b7e825a4e4c1-w")),
            SliverList(
                delegate: SliverChildBuilderDelegate((BuildContext c, int i) {
              if (i == 0) {
                return Container(
                  height: pinnedHeaderHeight,
                );
              }
              return oneList[i - 1];
            }, childCount: oneList.length + 1)),
            SliverPersistentHeader(
              pinned: true,
              delegate: StickyTabBarDelegate(
                  child: Container(
                height: 40,
                color: Colors.white,
                child: baseTabBar(tabController, getTabs(), (index) {
                  _model.selectTab(index);
                }, scroll: false),
              )),
            ),
          ];
        },
        body: TabBarView(controller: tabController, children: list));
  }

  List<Widget> getTabs() {
    List<Widget> list = [];
    for (int i = 0; i < _model.tabsList.length; i++) {
      list.add(baseTabBarItem(_model.tabsList[i].name,
          leftPadding: i == 0 ? 24 : 28,
          rightPadding: i == _model.tabsList.length - 1 ? 24 : 28));
    }
    return list;
  }

  Widget head() {
    return Container(
      key: keyTop,
      width: double.maxFinite,
      height: 200,
      alignment: Alignment.topLeft,
      decoration: BoxDecoration(
          image: DecorationImage(
              fit: BoxFit.cover,
              image: NetworkImage(
                  "https://pic.igengmei.com/2018/09/11/1513/b7e825a4e4c1-w"))),
//      child: ,
    );
  }

  Widget good() {
    if (_model.planoverItem == null) {
      return Container(
        height: 54,
      );
    }
    return Container(
      width: MediaQuery.of(context).size.width,
      height: 54,
      margin: EdgeInsets.only(top: 18, bottom: 12),
      child: Stack(
        children: <Widget>[
          Positioned(
            top: 6,
            left: 15,
            child: baseText(_model.planoverItem.name, 18, Color(0xff282828),
                bold: true),
          ),
          Positioned(
            bottom: 8,
            left: 15,
            child: baseText(
                _model.planoverItem.planDescription, 12, Color(0xff999999)),
          ),
          Positioned(
            right: 0,
            child: Container(
              width: 100,
              height: 54,
              decoration: BoxDecoration(
                  gradient: LinearGradient(colors: [
                Color(0xFFFFF0F5),
                Color(0xffFFF8FA),
                Color(0xFFFFFFFF)
              ], begin: FractionalOffset(1, 0), end: FractionalOffset(0, 1))),
            ),
          ),
          Positioned(
            right: 15,
            top: 6,
            child: Row(
              mainAxisSize: MainAxisSize.min,
              crossAxisAlignment: CrossAxisAlignment.end,
              children: <Widget>[
                baseText("好评率", 11, Color(0xff282828)),
                Container(
                  margin: EdgeInsets.only(left: 4),
                  child: baseText("${_model.planoverItem.positiveRate}", 20,
                      Color(0xffFF5963)),
                ),
//                baseText("%", 11, Color(0xffFF5963)),
              ],
            ),
          ),
          Positioned(
            right: 15,
            bottom: 8,
            child: baseText(
                "销量${_model.planoverItem.salesCount}", 11, Color(0xff666666)),
          )
        ],
      ),
    );
  }

  Widget rect() {
    if (_model.planoverItem == null) {
      return Container(
        height: 62,
      );
    }
    List<Widget> list = List();
    int i = 0;
    _model.planoverItem.overviewAttrs.forEach((element) {
      list.add(Expanded(
        child: Container(
          alignment: Alignment.center,
          child: Column(
            mainAxisSize: MainAxisSize.min,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: <Widget>[
              baseText(element.attrName, 14, Color(0xff282828), bold: true),
              baseText(element.attrValue, 11, Color(0xff999999)),
            ],
          ),
        ),
      ));
      if (i != _model.planoverItem?.overviewAttrs.length - 1) {
        list.add(Container(
          width: 0.5,
          height: 18,
          color: Color(0xFFE5E5E5),
        ));
      }
      i++;
    });
    return Container(
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(4),
        color: Color(0xffF9F8FB),
      ),
      width: double.maxFinite,
      height: 62,
      margin: EdgeInsets.only(left: 15, right: 15, bottom: 20),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: list,
      ),
    );
  }

  Widget explain() {
    List<Widget> list = [];
    list.add(Container(
      height: 31,
      child: Row(
        children: <Widget>[
          baseText("项目说明", 15, Color(0xff282828)),
          Expanded(
            child: Container(),
          ),
          GestureDetector(
            onTap: () {
              //TODO

              Map<String, dynamic> map = {};
              map["page_name"] = "plan_home";
              map["referrer_link"] = [];
              RouterCenterImpl()
                  .findMainRouter()
                  .buriedEvent("on_click_navbar_search", map);
            },
            behavior: HitTestBehavior.opaque,
            child: baseText("了解更多", 12, Color(0xff3FB5AF)),
          )
        ],
      ),
    ));
    if (_model.planoverItem != null) {
      _model.planoverItem.explanationAttrs.forEach((element) {
        list.add(Container(
          height: 28,
          child: Row(
            children: <Widget>[
              baseText(element.attrName, 13, Color(0xff999999)),
              Container(
                margin: EdgeInsets.only(left: 12),
                child: baseText(element.attrValue, 13, Color(0xff666666)),
              )
            ],
          ),
        ));
      });
    }
    return Container(
      margin: EdgeInsets.only(left: 15, right: 15, bottom: 20),
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: list,
      ),
    );
  }

//  Widget home() {
//    return Column(
//      children: <Widget>[
//        Expanded(
//          child: Stack(
//            children: <Widget>[
//              MediaQuery.removePadding(
//                  removeTop: true,
//                  context: context,
//                  child: NotificationListener(
//                    onNotification: (scrollNotification) {
//                      if (scrollNotification is ScrollUpdateNotification &&
//                          scrollNotification.metrics.axisDirection.index == 2) {
//                        _onScroll(scrollNotification.metrics.pixels);
//                      }
//                      return false;
//                    },
//                    child: baseRefreshView(
//                      _refreshController,
//                          () {
//                        //TODO
////                            _refreshController.refreshCompleted();
//                      },
//                      null,
//                      null,
//                      customScrollView: CustomScrollView(
//                        slivers: <Widget>[
//                          SliverList(
//                            delegate: SliverChildBuilderDelegate(
//                                  (BuildContext context, int index) {
//                                return oneList[index];
//                              },
//                              childCount: oneList.length,
//                            ),
//                          ),
//                        ],
//                      ),
//                      pullUp: true,
//                      onLoading: () {
//                        _model.loadMore();
//                      },
//                    ),
//                  )),
//              StreamBuilder<double>(
//                stream: _model.appBarLive.stream,
//                initialData: _model.appBarLive.data ?? 0.0,
//                builder: (c, data) {
//                  return Opacity(
//                    opacity: data.data,
//                    child: Container(
//                      height: 86,
//                      decoration: BoxDecoration(color: Colors.white),
//                      child: Center(
//                        child: Padding(
//                          padding: EdgeInsets.only(top: 20),
//                          child: Text('文案'),
//                        ),
//                      ),
//                    ),
//                  );
//                },
//              ),
//              baseSliverTitle("title", MediaQuery.of(context).size.width,
//                  _model.appBarLive),
//              Positioned(
//                top: 86,
//                child: StreamBuilder<bool>(
//                  stream: _model.showTab.stream,
//                  initialData: _model.showTab.data ?? false,
//                  builder: (c, data) {
//                    return Visibility(
//                        visible: data.data,
//                        child: Container(
//                          width: MediaQuery.of(context).size.width,
//                          color: Colors.white,
//                          child: MessageBarView(
//                            topIndexLive: _model.topIndexLive,
//                            topScrollLive: _model.topScrollLive,
//                            pageController: pageController,
//                          ),
//                        ));
//                  },
//                ),
//              ),
//              baseSliverBack(() {
//                Navigator.of(context).pop();
//              })
//            ],
//          ),
//        ),
//        Container(
//          height: 0.5,
//          width: double.maxFinite,
//          color: Color(0xffE5E5E5),
//        ),
//        Container(
//          width: double.maxFinite,
//          height: 55,
//          child: Row(
//            mainAxisSize: MainAxisSize.min,
//            crossAxisAlignment: CrossAxisAlignment.center,
//            children: <Widget>[
//              Container(
//                margin: EdgeInsets.only(left: 18),
//                width: 30,
//                child: Column(
//                  mainAxisSize: MainAxisSize.min,
//                  children: <Widget>[
//                    Container(
//                      width: 22,
//                      height: 22,
//                      child: Image.asset("assets/vs_black.png"),
//                    ),
//                    Container(
//                      margin: EdgeInsets.only(top: 3),
//                      child: baseText("去比较", 10, Color(0xff282828)),
//                    )
//                  ],
//                ),
//              ),
//              GestureDetector(
//                  behavior: HitTestBehavior.opaque,
//                  onTap: () {},
//                  child: Container(
//                    margin: EdgeInsets.only(left: 15),
//                    width: 135,
//                    height: 40,
//                    decoration: BoxDecoration(
//                        color: Color(0xff51CDC7),
//                        borderRadius: BorderRadius.circular(20)),
//                    alignment: Alignment.center,
//                    child: baseText("咨询", 14, Colors.white, bold: true),
//                  )),
//              GestureDetector(
//                  behavior: HitTestBehavior.opaque,
//                  onTap: () {},
//                  child: Container(
//                    margin: EdgeInsets.only(left: 15),
//                    width: 135,
//                    height: 40,
//                    decoration: BoxDecoration(
//                        color: Color(0xffF96079),
//                        borderRadius: BorderRadius.circular(20)),
//                    alignment: Alignment.center,
//                    child: baseText("获取底价", 14, Colors.white, bold: true),
//                  )),
//              Expanded(
//                child: Container(),
//              )
//            ],
//          ),
//        )
//      ],
//    );
//  }
}
