/*
 * @author lsy
 * @date   2020/6/30
 **/
import 'dart:convert';

import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/ClueModel/page/plan/PlanModelInstance.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanBean.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanFeedBean.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/cache/CacheManager.dart';
import 'package:gm_flutter/commonModel/eventbus/SimpleEventBus.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:gm_flutter/commonModel/util/PrintUtil.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class PlanModel extends BaseModel {
  LiveData<List> managerLive = new LiveData();
  LiveData<List<double>> posLive = new LiveData();
  LiveData<List<double>> backLive = new LiveData();
  LiveData<List<Ranks>> picLive = LiveData();
  LiveData<bool> showTab = LiveData();
  LiveData<int> stateLive = LiveData();
  LiveData<Pair<int, List<Plans>>> feedsLive = LiveData();
  RxDispose rxDispose = RxDispose();
  double menuBottom;
  int menuIndex = -1;
  bool needChangBack = true;
  String current_city_id = "";
  String rank_type = "";

  List<Plans> feedDatas = [];
  List<Tags> projectData = [];
  List<Orders> sortList = [];
  List<String> normalData = ["全部项目", "智能筛选", "筛选"];

  String tag_id = "0";
  String order_by = "";
  String min_price = "0";
  String max_price = "100000000";
  int low = 0;
  int high = 20100;
  int projectSelectIndex = 0;
  PlanBean planBean;

  int page = 1;
  int sortPos = 0;

  void init({VoidCallback call, bool needCache = false}) {
    if (PlanModelInstance.getInstance().planBean != null && needCache) {
      planBean = PlanModelInstance.getInstance().planBean;
      projectData = planBean.data.tags;
      sortList = planBean.data.orders;
      picLive.notifyView(planBean.data.ranks);
      low = PlanModelInstance.getInstance().low;
      high = PlanModelInstance.getInstance().high;
      print("QWEEW${low} ${high}");

      projectSelectIndex = PlanModelInstance.getInstance().projectSelectIndex;

      stateLive.notifyView(ENDLOADING);
      normalData.clear();
      normalData.addAll(PlanModelInstance.getInstance().normalData);
      managerLive.notifyView(normalData);
      tag_id = PlanModelInstance.getInstance().tag_id;
      order_by = PlanModelInstance.getInstance().order_by;
      min_price = PlanModelInstance.getInstance().min_price;
      max_price = PlanModelInstance.getInstance().max_price;
      sortPos = PlanModelInstance.getInstance().sortPos;
      if (call != null) {
        call();
      }
      refreshFeed(true, needCache: needCache);
      return;
    }
    ClueApiImpl.getInstance()
        .getPlan(DioUtil.getInstance().getDio())
        .listen((event) {
          if (event.error == 0) {
            projectData = event.data.tags;
            if (event.data.tags != null &&
                event.data.tags.length > 0 &&
                event.data.tags[0].subtags != null &&
                event.data.tags[0].subtags.length > 0) {
              tag_id = "${event.data.tags[0].subtags[0].tagId}";
              normalData[0] = "${event.data.tags[0].subtags[0].name}";
            }
            sortList = event.data.orders;
            order_by = "${sortList[0].id}";
            min_price = "0";
            max_price = "100000000";
            low = 0;
            projectSelectIndex = 0;
            high = 20100;
            sortPos = 0;
            picLive.notifyView(event.data.ranks);
            stateLive.notifyView(ENDLOADING);
            normalData[1] = event.data.orders[0].name;
            managerLive.notifyView(normalData);
            if (call != null) {
              SimpleEventBus.instance().notifyListener("FilterViewState", "reset");
              SimpleEventBus.instance().notifyListener("ProjectViewState", "reset");
              call();
            }
            refreshFeed(true, needCache: needCache);
            PlanModelInstance.getInstance().planBean = event;
          } else {
            stateLive.notifyView(FAIL);
            NativeToast.showNativeToast(event.message);
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          print("ERROR12WCCCCCC  ${err.toString()}");
          PrintUtil.printBug(err);
          stateLive.notifyView(FAIL);
        });
  }

  void projectClick(String id, String name, int index) {
    if (tag_id == id) {
      return;
    }
    projectSelectIndex = index;
    normalData[0] = name;
    managerLive.notifyView(normalData);
    tag_id = id;
    feedsLive.notifyView(Pair(LOADING, null));
    refreshFeed(true);
  }

  void refreshFeed(bool clear,
      {RefreshController controller, bool needCache = false}) {
    if (needCache && PlanModelInstance.getInstance().feedDatas != null) {
      page = PlanModelInstance.getInstance().page;
      feedDatas.clear();
      feedDatas.addAll(PlanModelInstance.getInstance().feedDatas);
      if (feedDatas.isEmpty) {
        feedsLive.notifyView(Pair(EMPTY, null));
      } else {
        feedsLive.notifyView(Pair(ENDLOADING, feedDatas));
      }
//      WidgetsBinding.instance.addPostFrameCallback((_) {
//        SimpleEventBus.instance()
//            .notifyListener("BaseNestedScrollViewRefreshIndicator", "refresh");
//      });
      return;
    }
    if (clear) {
      page = 1;
      feedDatas.clear();
    }
    ClueApiImpl.getInstance()
        .getPlanFeed(DioUtil.getInstance().getDio(), tag_id, order_by,
            current_city_id, min_price, max_price, rank_type, page)
        .listen((event) {
          if (event.error == 0) {
            if (event.data.plans == null || event.data.plans.isEmpty) {
              if (page == 1) {
                feedsLive.notifyView(Pair(EMPTY, []));
              } else {
                feedsLive.notifyView(Pair(ENDLOADING, []));
              }
            } else {
              feedDatas.addAll(event.data.plans);
              feedsLive.notifyView(Pair(ENDLOADING, feedDatas));
            }
            controller?.refreshCompleted();
            if (PlanModelInstance.getInstance().feedDatas == null) {
              PlanModelInstance.getInstance().feedDatas = [];
            }
            PlanModelInstance.getInstance().feedDatas.clear();
            PlanModelInstance.getInstance().feedDatas.addAll(feedDatas);
          } else {
            NativeToast.showNativeToast(event.message);
            feedsLive.notifyView(Pair(FAIL, null));
            controller?.refreshFailed();
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          PrintUtil.printBug(err);
          print("PLANERROR ${err}");
          feedsLive.notifyView(Pair(FAIL, null));
          controller?.refreshFailed();
        });
  }

  @override
  void dispose() {
    PlanModelInstance.getInstance().normalData.clear();
    PlanModelInstance.getInstance().normalData.addAll(normalData);
    PlanModelInstance.getInstance().tag_id = tag_id;
    PlanModelInstance.getInstance().projectSelectIndex = projectSelectIndex;
    PlanModelInstance.getInstance().order_by = order_by;
    PlanModelInstance.getInstance().min_price = min_price;
    PlanModelInstance.getInstance().max_price = max_price;
    PlanModelInstance.getInstance().sortPos = sortPos;
    PlanModelInstance.getInstance().low = low;
    PlanModelInstance.getInstance().high = high;
    stateLive.dispost();
    picLive.dispost();
    rxDispose.dispose();
    managerLive.dispost();
    posLive.dispost();
    backLive.dispost();
    feedsLive.dispost();
    showTab.dispost();
  }

  void backProgress(double pro, int index) {
    if (needChangBack || menuIndex == -1) {
      backLive.notifyView([0.0, menuBottom, pro]);
    }
  }

  void loadMore() {
    page++;
    refreshFeed(false);
  }

  void sortClick(int index) {
    if (index == sortPos) {
      return;
    }
    sortPos = index;
    order_by = sortList[index].id.toString();
    normalData[1] = "${sortList[index].name}";
    managerLive.notifyView(normalData);
    feedsLive.notifyView(Pair(LOADING, null));
    refreshFeed(true);
  }

  void filterClick(int max, int min) {
    if (max_price == "${max}" && min_price == "${min}") {
      return;
    }
    low = min;
    high = max > 20000 ? 20000 : max;
    if (max > 20000) {
      max = 20000000;
    }
    max_price = "${max}";
    min_price = "${min}";
    feedsLive.notifyView(Pair(LOADING, null));
    refreshFeed(true);
  }
}
