/*
 * @author lsy
 * @date   2020/6/29
 **/
import 'dart:math';

import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/commonModel/net/DioUtil.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:gm_flutter/commonModel/util/PrintUtil.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';

class MechanismModel extends BaseModel {
  LiveData<List<String>> questionsLive = LiveData();

  LiveData<int> stateLive = LiveData();
  LiveData messageLive = LiveData();
  RxDispose rxDispose = RxDispose();

  getQuestions(int plan_id) {
    ClueApiImpl.getInstance()
        .getConsultQuestions(DioUtil.getInstance().getDio(), plan_id)
        .listen((event) {
          if (event.error == 0) {
            stateLive.notifyView(ENDLOADING);
            questionsLive.notifyView(event.data.questions);
          } else {
            stateLive.notifyView(FAIL);
            questionsLive.notifyView(null);
            NativeToast.showNativeToast(event.message);
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          stateLive.notifyView(FAIL);
          questionsLive.notifyView(null);
          PrintUtil.printBug(err);
        });
  }

  sendMessage(List<int> doctor_ids, String question, int plan_id,
      Function(int state) func) {
    ClueApiImpl.getInstance()
        .sendMessage(
            DioUtil.getInstance().getDio(), doctor_ids, question, plan_id)
        .listen((event) {
          if (event.error == 0) {
            func(0);
            messageLive.notifyView(event.data.success);
          } else {
            NativeToast.showNativeToast(event.message);
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          PrintUtil.printBug(err);
        });
  }

  @override
  void dispose() {
    questionsLive.dispost();
    stateLive.dispost();
    rxDispose.dispose();
  }
}
