/*
 * @author lsy
 * @date   2020/6/30
 **/
import 'package:flutter/foundation.dart';
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/ClueModel/page/plan/PlanTest.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanBean.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanFeedBean.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:gm_flutter/commonModel/util/PrintUtil.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class PlanModel extends BaseModel {
  LiveData<List> managerLive = new LiveData();
  LiveData<List<double>> posLive = new LiveData();
  LiveData<List<double>> backLive = new LiveData();
  LiveData<List<Ranks>> picLive = LiveData();
  LiveData<bool> showTab = LiveData();
  LiveData<int> stateLive = LiveData();

  double menuBottom;
  int menuIndex = -1;
  bool needChangBack = true;
  LiveData<Pair<int, List<Plans>>> feedsLive = LiveData();
  List<Plans> feedDatas = [];

  List<Tags> projectData = [];
  List<Orders> sortList = [];
  RxDispose rxDispose = RxDispose();

  String tag_id = "";
  String order_by = "";
  String current_city_id = "";
  String min_price = "";
  String max_price = "";
  String rank_type = "";
  int page = 1;
  int sortPos = 0;

  void init() {
    ClueApiImpl.getInstance()
        .getPlan(DioUtil.getInstance().getDio())
        .listen((event) {
          if (event.error == 0) {
            projectData = event.data.tags;
            sortList = event.data.orders;
            picLive.notifyView(event.data.ranks);
            stateLive.notifyView(ENDLOADING);
            refreshFeed(true);
          } else {
            stateLive.notifyView(FAIL);
            NativeToast.showNativeToast(event.message);
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          print("ERROR12WCCCCCC  ${err.toString()}");
          PrintUtil.printBug(err);
          stateLive.notifyView(FAIL);
        });
  }

  void projectClick(String id) {
    if (tag_id == id) {
      return;
    }
    tag_id = id;
    feedsLive.notifyView(Pair(LOADING, null));
    refreshFeed(true);
  }

  void refreshFeed(bool clear, {RefreshController controller}) {
    if (clear) {
      feedDatas.clear();
    }
    ClueApiImpl.getInstance()
        .getPlanFeed(DioUtil.getInstance().getDio(), tag_id, order_by,
            current_city_id, min_price, max_price, rank_type, page)
        .listen((event) {
          if (event.error == 0) {
            if (event.data.plans == null || event.data.plans.isEmpty) {
              feedsLive.notifyView(Pair(ENDLOADING, []));
            } else {
              feedDatas.addAll(event.data.plans);
              feedsLive.notifyView(Pair(ENDLOADING, feedDatas));
            }
            controller?.refreshCompleted();
          } else {
            NativeToast.showNativeToast(event.message);
            feedsLive.notifyView(Pair(FAIL, null));
            controller?.refreshFailed();
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          PrintUtil.printBug(err);
          feedsLive.notifyView(Pair(FAIL, null));
          controller?.refreshFailed();
        });
  }

  @override
  void dispose() {
    stateLive.dispost();
    picLive.dispost();
    rxDispose.dispose();
    managerLive.dispost();
    posLive.dispost();
    backLive.dispost();
    feedsLive.dispost();
    showTab.dispost();
  }

  void backProgress(double pro, int index) {
    if (needChangBack || menuIndex == -1) {
      backLive.notifyView([0.0, menuBottom, pro]);
    }
  }

  void loadMore() {
    page++;
    refreshFeed(false);
  }

  void sortClick(int index) {
    if (index == sortPos) {
      return;
    }
    sortPos = index;
    order_by = sortList[index].id.toString();
    refreshFeed(true);
  }

  void filterClick(int max, int min) {
    if (max_price == max.toString() && min_price == min.toString()) {
      return;
    }
    max_price = max.toString();
    min_price = min.toString();
    refreshFeed(true);
  }
}
