/*
 * @author lsy
 * @date   2020/7/1
 **/
class PlanBean {
  int error;
  String message;
  String extra;
  String errorExtra;
  UserType userType;
  Data data;

  PlanBean(
      {this.error,
      this.message,
      this.extra,
      this.errorExtra,
      this.userType,
      this.data});

  PlanBean.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra']??"";
    errorExtra = json['error_extra']??"";
    userType = json['user_type'] != null
        ? new UserType.fromJson(json['user_type'])
        : null;
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    data['error_extra'] = this.errorExtra;
    if (this.userType != null) {
      data['user_type'] = this.userType.toJson();
    }
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    return data;
  }
}

class UserType {
  UserType();

  UserType.fromJson(Map<String, dynamic> json) {}

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    return data;
  }
}

class Data {
  List<Ranks> ranks;
  List<Areas> areas;
  List<Tags> tags;
  List<Orders> orders;

  Data({this.ranks, this.areas, this.tags, this.orders});

  Data.fromJson(Map<String, dynamic> json) {
    if (json['ranks'] != null) {
      ranks = new List<Ranks>();
      json['ranks'].forEach((v) {
        ranks.add(new Ranks.fromJson(v));
      });
    }
    if (json['areas'] != null) {
      areas = new List<Areas>();
      json['areas'].forEach((v) {
        areas.add(new Areas.fromJson(v));
      });
    }
    if (json['tags'] != null) {
      tags = new List<Tags>();
      json['tags'].forEach((v) {
        tags.add(new Tags.fromJson(v));
      });
    }
    if (json['orders'] != null) {
      orders = new List<Orders>();
      json['orders'].forEach((v) {
        orders.add(new Orders.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.ranks != null) {
      data['ranks'] = this.ranks.map((v) => v.toJson()).toList();
    }
    if (this.areas != null) {
      data['areas'] = this.areas.map((v) => v.toJson()).toList();
    }
    if (this.tags != null) {
      data['tags'] = this.tags.map((v) => v.toJson()).toList();
    }
    if (this.orders != null) {
      data['orders'] = this.orders.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Ranks {
  int id;
  String name;
  String gmUrl;
  String icon;

  Ranks({this.name, this.gmUrl, this.icon});

  Ranks.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    gmUrl = json['gm_url'];
    icon = json['icon'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['name'] = this.name;
    data['id'] = this.id;
    data['gm_url'] = this.gmUrl;
    data['icon'] = this.icon;
    return data;
  }
}

class Areas {
  bool isLocated;
  String name;
  List<Groups> groups;

  Areas({this.isLocated, this.name, this.groups});

  Areas.fromJson(Map<String, dynamic> json) {
    isLocated = json['is_located'];
    name = json['name'];
    if (json['groups'] != null) {
      groups = new List<Groups>();
      json['groups'].forEach((v) {
        groups.add(new Groups.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['is_located'] = this.isLocated;
    data['name'] = this.name;
    if (this.groups != null) {
      data['groups'] = this.groups.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Groups {
  bool isHot;
  String initial;
  List<Cities> cities;
  String title;

  Groups({this.isHot, this.initial, this.cities, this.title});

  Groups.fromJson(Map<String, dynamic> json) {
    isHot = json['is_hot'];
    initial = json['initial'];
    if (json['cities'] != null) {
      cities = new List<Cities>();
      json['cities'].forEach((v) {
        cities.add(new Cities.fromJson(v));
      });
    }
    title = json['title'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['is_hot'] = this.isHot;
    data['initial'] = this.initial;
    if (this.cities != null) {
      data['cities'] = this.cities.map((v) => v.toJson()).toList();
    }
    data['title'] = this.title;
    return data;
  }
}

class Cities {
  String cityName;
  String id;
  String name;

  Cities({this.cityName, this.id, this.name});

  Cities.fromJson(Map<String, dynamic> json) {
    cityName = json['city_name'];
    id = json['id'].toString();
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['city_name'] = this.cityName;
    data['id'] = this.id;
    data['name'] = this.name;
    return data;
  }
}

class Tags {
  String id;
  List<SubTags> subTags;
  String name;

  Tags({this.id, this.subTags, this.name});

  Tags.fromJson(Map<String, dynamic> json) {
    id = json['id'].toString();
    if (json['sub_tags'] != null) {
      subTags = new List<SubTags>();
      json['sub_tags'].forEach((v) {
        subTags.add(new SubTags.fromJson(v));
      });
    }
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    if (this.subTags != null) {
      data['sub_tags'] = this.subTags.map((v) => v.toJson()).toList();
    }
    data['name'] = this.name;
    return data;
  }
}

class SubTags {
  String id;
  String name;

  SubTags({this.id, this.name});

  SubTags.fromJson(Map<String, dynamic> json) {
    id = json['id'].toString();
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    return data;
  }
}

class Orders {
  int id;
  String name;

  Orders({this.id, this.name});

  Orders.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    return data;
  }
}
