/*
 * @author lsy
 * @date   2020/6/29
 **/
import 'dart:async';

import 'package:flutter/services.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/base/BaseUtil.dart';
import 'package:gm_flutter/commonModel/cache/CacheManager.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';

import '../../commonModel/App.dart';

class MainManager {
  MethodChannel flutterChannel;
  EventChannel flutterEvent;
  bool isInit = false;

  MainManager._() {}

  static MainManager _mainManager;

  static MainManager getInstance() {
    if (_mainManager == null) {
      _mainManager = MainManager._();
    }
    return _mainManager;
  }

  startInit() {
    if (isInit) {
      return;
    }
    isInit = true;
    print("LSY STATEINIT METHOD AND CHANNEL ");
    flutterChannel = MethodChannel('gm_method_channel');
    flutterEvent = EventChannel('gm_method_event');
    flutterEvent.receiveBroadcastStream().listen((data) {
      if (data is Map) {
        print("LSY STATEINIT OKKK ${data}");
        var map = Map<String, dynamic>.from(data);
        initParams(map);
      }
    });
  }

  void initParams(Map<String, dynamic> map) {
    innerSetData(map, APP_NAME);
    innerSetData(map, VERSION);
    innerSetData(map, PLATFORM);
    innerSetData(map, DEVICE_ID);
    innerSetData(map, OS_VERSION);
    innerSetData(map, MODEL);
    innerSetData(map, SCREEN);
    innerSetData(map, LAT);
    innerSetData(map, LNG);
    innerSetData(map, CHANNEL);
    innerSetData(map, MANUFACTURER);
    innerSetData(map, UUID);
    innerSetData(map, ANDROID_DEVICE_ID);
    innerSetData(map, CURRENT_CITY_ID);
    innerSetData(map, RELEASE);
    innerSetData(map, IDFA);
    innerSetData(map, IDFV);
    innerSetData(map, IS_WIFI);
    innerSetData(map, HARDWARE_MODEL);
    innerSetData(map, USER_ID);
    innerSetData(map, USER_AGENT);


    innerSetData(map, BASE_URL);
    DioUtil.setDefOptions(
        baseUrl: "${map[BASE_URL]}/",
        agent: map[USER_AGENT]);
    if (map[COOKIE] == null) {
      CacheManager.getInstance().get(MEMORY_CACHE).save(COOKIE,
          "_gm_token=1da6071594101423; csrftoken=rUrkkYYMOVZfIIQnU2IH09QIGmsfe8tE; sessionid=uz7f70uap76r6og48znci5l2hbr9vm5c; _gtid=5af9a5deba8511ea8d4082a085c393c93393");
    } else {
      innerSetData(map, COOKIE);
    }
    print(
        "LSY QQWWEERRTTYY ${CacheManager.getInstance().get(MEMORY_CACHE).get(COOKIE)}"
            "  ${CacheManager.getInstance().get(MEMORY_CACHE).get(COOKIE) is String}");
    DioUtil.getInstance().changeOpt();
  }

  void innerSetData(Map<String, dynamic> map, String str) {
    if (map[str] != null && "${map[str]}".isNotEmpty) {
      CacheManager.getInstance().get(MEMORY_CACHE).save(str, "${map[str]}");
    }
  }

  void buriedEvent(String name, Map<String, dynamic> map) {
    if (!isInit) {
      return;
    }
    if (flutterChannel != null) {
      flutterChannel.invokeMethod("buried-${name}", map);
    }
  }

  void catchErrorToBugly(String err) {
    if (!isInit) {
      return;
    }
    if (flutterChannel != null) {
      flutterChannel.invokeMethod("wrong_report_bugly", err ?? "");
    }
  }

  Future getInitParams() async {
    Completer completer = Completer();
    if (isInit) {
      if (flutterChannel != null) {
        var data = await flutterChannel.invokeMethod("get_common_params");
        if (data is Map) {
          var map = Map<String, dynamic>.from(data);
          initParams(map);
        }
      }
    }
    completer.complete();
    return completer.future;
  }
}
