/*
 * @author lsy
 * @date   2019-12-31
 **/
import 'package:dio/dio.dart';
import 'package:flutter/src/widgets/framework.dart';
import 'package:gm_flutter/MainRouter/manager/JumpManager.dart';
import 'package:gm_flutter/MainRouter/manager/MainManager.dart';
import 'package:gm_flutter/MainRouter/page/proxy/NetProxyPage.dart';
import 'package:gm_flutter/MainRouter/page/test/TestPage.dart';

import 'MainRouter.dart';

class MainRouterImpl implements MainRouter {
  @override
  void init() {
    MainManager.getInstance().startInit();
  }

  @override
  Widget getTestPage() {
    return TestPage();
  }

  @override
  void buriedEvent(String name, Map<String, dynamic> map) {
    MainManager.getInstance().buriedEvent(name, map);
  }

  @override
  void jumpPage(BuildContext context, String pageName,
      Map<String, dynamic> params, bool nativePage) {
    JumpManager.instance().jumpToPage(context, pageName, params, nativePage);
  }

  @override
  Widget getProxyPage() {
    return NetProxyPage();
  }

  @override
  void catchErrorToBugly(String err) {
    MainManager.getInstance().catchErrorToBugly(err);
  }

  @override
  bool isWithNative() {
    return MainManager.getInstance().isInit;
  }
}
