import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlansCompareFeed.dart';
import 'package:gm_flutter/ClueModel/util/NumPlanUtil.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';

import 'CallBackCompareItem.dart';

class PlansCompareFeedItemView extends StatefulWidget {
  Plans plan;
  CallBackCompareItem compareItem;
  Set<int> _setCompare;

  PlansCompareFeedItemView(this.plan, this.compareItem, this._setCompare);

  @override
  State<StatefulWidget> createState() => _PlansCompareFeedItemViewState();
}

class _PlansCompareFeedItemViewState
    extends BaseState<PlansCompareFeedItemView> {
  String _checked = "assets/icon_compare_select.png";
  String _unchecked = "assets/icon_compare_unselect.png";
  String _icon = "assets/icon_compare_unselect.png";

  @override
  Widget buildItem(BuildContext context) {
    return Container(
        margin: EdgeInsets.only(left: 15, right: 15),
        child: Column(
          children: <Widget>[
            getItem(),
            Divider(height: 0.5, color: Color(0xFFE5E5E5))
          ],
        ));
  }

  getItem() {
    if (widget.plan.planType == 1) {
      return getFirstLevelItem();
    } else {
      return getSecondLevelItem();
    }
  }

  getFirstLevelItem() {
    String price =
        NumPlanUtil.getPrice(widget.plan.minPrice, widget.plan.maxPrice);
    return Container(
      width: double.maxFinite,
      height: 80,
      alignment: Alignment.centerLeft,
      padding: EdgeInsets.only(top: 15, bottom: 15),
      child: Row(
        children: <Widget>[
          Container(
            alignment: Alignment.center,
            child: Image.asset(
              _icon,
              width: 17,
              height: 17,
            ),
          ),
          Container(
            margin: EdgeInsets.only(left: 15, right: 12),
            child: ClipRRect(
              borderRadius: BorderRadius.circular(4.0),
              child: CachedNetworkImage(
                imageUrl: widget.plan.projectImage ?? "",
                width: 50,
                height: 50,
                fit: BoxFit.cover,
              ),
            ),
          ),
          Expanded(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Container(
                  margin: EdgeInsets.only(top: 2, bottom: 8),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: <Widget>[
                      baseText(widget.plan.name, 14, Color(0xFF282828),
                          bold: true),
                      Text.rich(TextSpan(children: [
                        TextSpan(
                            text: "好评率 ",
                            style: TextStyle(
                                fontSize: 11, color: Color(0xFF282828))),
                        TextSpan(
                            text:
                                "${(widget.plan.positiveRate.contains(".") ? widget.plan.positiveRate.split(".")[0] : widget.plan.positiveRate).replaceAll("%", "")}",
                            style: TextStyle(
                                fontSize: 14,
                                color: Color(0xFFFF5963),
                                fontWeight: FontWeight.w500)),
                        TextSpan(
                            text: "%",
                            style: TextStyle(
                                fontSize: 10,
                                color: Color(0xFFFF5963),
                                fontWeight: FontWeight.w500))
                      ])),
                    ],
                  ),
                ),
                Row(
                  children: <Widget>[
                    price == "暂无报价"
                        ? Container(
                            width: 0,
                            height: 0,
                          )
                        : baseText("¥", 12, Color(0xFFFF5963)),
                    baseText(price, price == "暂无报价" ? 13 : 15,
                        price == "暂无报价" ? Color(0xFF666666) : Color(0xFFFF5963),
                        bold: price != "暂无报价"),
                    Expanded(
                      child: Container(),
                    ),
                    baseText(
                        "销量${widget.plan.salesCount}", 11, Color(0xFF666666))
                  ],
                )
              ],
            ),
          )
        ],
      ),
    ).gestureDetector(() {
      onClickCheckBox(_icon);
    });
  }

  getSecondLevelItem() {
    String price =
        NumPlanUtil.getPrice(widget.plan.minPrice, widget.plan.maxPrice);
    return Container(
      height: 77,
      child: Row(
        children: <Widget>[
          Container(
              margin: EdgeInsets.only(right: 15.0),
              alignment: Alignment.centerLeft,
              child: Container(
                  alignment: Alignment.center,
                  child: Image.asset(
                    _icon,
                    width: 17,
                    height: 17,
                    fit: BoxFit.fill,
                  ))),
          Expanded(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Container(
                  margin: EdgeInsets.only(top: 13.0, bottom: 12),
                  child: baseText(widget.plan.name, 14, Color(0xFF282828),
                      bold: true),
                ),
                Row(
                  children: <Widget>[
                    price == "暂无报价"
                        ? Container(
                            width: 0,
                            height: 0,
                          )
                        : baseText("¥", 12, Color(0xFFFF5963)),
                    baseText(price, price == "暂无报价" ? 13 : 15,
                        price == "暂无报价" ? Color(0xFF666666) : Color(0xFFFF5963),
                        bold: price != "暂无报价"),
                    Expanded(
                      child: Container(),
                    ),
                    baseText("指导价：${widget.plan.guidePrice ?? "暂无报价"}", 11,
                        Color(0xff666666)),
                  ],
                ),
              ],
            ),
          )
        ],
      ),
    ).gestureDetector(() {
      onClickCheckBox(_icon);
    });
  }

  onClickCheckBox(String icon) {
    if (icon == _checked) {
      _icon = _unchecked;
    } else {
      if (widget._setCompare.length == 2) {
        NativeToast.showNativeToast("请选择最多2个项目进行对比");
        return;
      }
      _icon = _checked;
    }
    setState(() {
      widget.compareItem.checkedItem(widget.plan.planId);
    });
  }
}
