/*
 * @author lsy
 * @date   2020/7/1
 **/
import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanFeedBean.dart';
import 'package:gm_flutter/ClueModel/util/NumPlanUtil.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';
import 'package:gm_flutter/main.mark.dart';

class PlanItem extends StatelessWidget {
  final Plans plans;
  final int pos;
  final bool isPlanPage;
  String tabName;

  PlanItem(this.plans, this.pos, this.isPlanPage, this.tabName);

  @override
  Widget build(BuildContext context) {
    List<Widget> list = [];
    int i = 0;
    plans.baseAttrs.forEach((element) {
      list.add(baseText("${element}", 11, Color(0xff999999)));
      if (i != plans.baseAttrs.length - 1) {
        list.add(Container(
          width: 8.5,
          height: 8,
          alignment: Alignment.center,
          child: Container(
            width: 0.5,
            height: 8,
            decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(0.5),
                color: Color(0xff999999)),
          ),
        ));
      }
      i++;
    });

    String rate = plans.positiveRate;
    if (rate != null && rate.contains(".")) {
      rate = rate.split(".")[0];
    }
    rate = rate.replaceAll("%", "");
    return Container(
        margin: EdgeInsets.only(top: 10, left: 10, right: 10),
        child: Card(
          elevation: 3.0,
          child: Container(
            height: 90,
            decoration: BoxDecoration(
                color: Colors.white, borderRadius: BorderRadius.circular(4)),
            child: Stack(
              children: <Widget>[
                Positioned(
                  top: 10,
                  left: 10,
                  child: Container(
                    width: 70,
                    height: 70,
                    child: ClipRRect(
                      borderRadius: BorderRadius.circular(4),
                      child: CachedNetworkImage(
                        imageUrl: plans.projectImage,
                        fit: BoxFit.cover,
                      ),
                    ),
                  ),
                ),
                Positioned(
                  left: 92,
                  top: 14,
                  child: Row(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisSize: MainAxisSize.min,
                    children: <Widget>[
                      Container(
                        constraints: BoxConstraints(maxWidth: 110),
                        child: baseText(plans.name, 14, Color(0xff282828),
                            bold: true),
                      ),
                      plans.operation_type.empty()
                          ? Container(
                              width: 0,
                              height: 0,
                            )
                          : Container(
                              constraints: BoxConstraints(maxWidth: 60),
                              margin: EdgeInsets.only(left: 4),
                              child: Container(
                                padding: EdgeInsets.only(
                                    top: 2, bottom: 2, left: 3, right: 3),
                                decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(2),
                                    color: Color(0xffF0F9F7)),
                                alignment: Alignment.center,
                                child: baseText("${plans.operation_type}", 11,
                                    Color(0xff3FB5AF),
                                    bold: true),
                              ),
                            )
                    ],
                  ),
                ),
                Positioned(
                  top: 15,
                  right: 10,
                  child: Row(
                    mainAxisSize: MainAxisSize.min,
//                crossAxisAlignment: CrossAxisAlignment.end,
                    verticalDirection: VerticalDirection.down,
                    children: <Widget>[
                      baseText("好评率", 11, Color(0xff282828)),
                      Container(
                        width: 4,
                      ),
                      baseText("${rate}", 14, Color(0xffFF5963), bold: true),
                      baseText("%", 10, Color(0xffFF5963)),
                    ],
                  ),
                ),
                Positioned(
                  bottom: 14,
                  right: 10,
                  child:
                      baseText("销量${plans.salesCount}", 11, Color(0xff282828)),
                ),
                Positioned(
                  left: 91,
                  bottom: 14,
                  child: Row(
                    verticalDirection: VerticalDirection.down,
                    mainAxisSize: MainAxisSize.min,
                    children: <Widget>[
                      baseText("¥", 10, Color(0xffFF5963)),
                      baseText("${plans.minPrice}-${plans.maxPrice}", 13,
                          Color(0xffFF5963),
                          bold: true),
                    ],
                  ),
                ),
                Positioned(
                  left: 92,
                  top: 36,
                  child: Row(
                    mainAxisSize: MainAxisSize.min,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: list,
                  ),
                )
              ],
            ),
          ),
        ).gestureDetector(() {
          Map<String, dynamic> buriedMap = {
            "tab_name": tabName,
            "position": pos,
            "card_id": plans.id,
            "card_type": "card",
            "transaction_type": "",
            "card_content_type": "level_one_plan"
          };
          RouterCenterImpl()
              .findMainRouter()
              .buriedEvent("on_click_card", buriedMap);
          Map<String, dynamic> map = {
            "business_id": "${plans.id}",
            "planId": plans.id,
            "title": "${plans.name}"
          };
          RouterCenterImpl()
              .findMainRouter()
              .jumpPage(context, "level_one_plan_detail", map, false);
        }));
  }
}
