/*
 * @author lsy
 * @date   2020/7/1
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';

class PlanProgressBar extends StatefulWidget {
  int low;
  int high;
  int maxlow;
  int maxHigh;
  int padding;

  PlanProgressBar(this.low, this.high, this.maxlow, this.maxHigh,
      {this.padding});

  @override
  State<StatefulWidget> createState() => PlanProgressBarState();
}

class PlanProgressBarState extends State<PlanProgressBar> {
  double distance;
  double leftStarPosPercent;
  double leftPosTempPercent;

  double rightStarPosPercent;
  double rightPosTempPercent;
  double leftDowPos;
  double rightDowPos;

  double scrollDistance;

  double leftPos;

  double textLeft = -1;
  bool isLeftMove = true;

  @override
  void initState() {
    super.initState();
    distance = widget.maxHigh - widget.maxlow - 0.0;
    leftStarPosPercent = (widget.low / distance);
    leftPosTempPercent = leftStarPosPercent;

    rightStarPosPercent = (widget.high / distance);
    rightPosTempPercent = rightStarPosPercent;
  }

  @override
  Widget build(BuildContext context) {
    double totle = MediaQuery.of(context).size.width - widget.padding * 2 - 8;
    scrollDistance = 0.05;
    double textL = textLeft * totle - 67.5 / 2 + 9;
    if (textL < 0) {
      textL = 0;
    } else if (textL + 67.5 > totle) {
      textL = totle - 67.5;
    }
    return Container(
      width: double.maxFinite,
      height: 65,
      child: Stack(
        children: <Widget>[
          Positioned(
            bottom: 7.5,
            left: 4,
            child: Container(
              width: totle,
              height: 4,
              decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(50),
                  color: Color(0xffD5D5D5)),
            ),
          ),
          Positioned(
            left: leftPosTempPercent * totle + 5,
            bottom: 7.5,
            child: Container(
              height: 4,
              width: (rightPosTempPercent - leftPosTempPercent) * totle,
              color: Color(0xff51CDC7),
            ),
          ),
          Positioned(
            left: textL,
            bottom: 23,
            child: Visibility(
              visible: textLeft >= 0,
              child: Container(
                width: 67.5,
                height: 42,
                color: Color(0x66000000),
                alignment: Alignment.center,
                child: Column(
                  children: <Widget>[
                    baseText(
                        "${(widget.maxlow + (isLeftMove?leftPosTempPercent:rightPosTempPercent+0.03) * distance).toInt()}",
                        13,
                        Colors.white)
                  ],
                ),
              ),
            ),
          ),
          Positioned(
              bottom: 0,
              left: leftPosTempPercent * totle,
              child: Listener(
                onPointerDown: (p) {
                  leftDowPos = p.localPosition.dx;
                  isLeftMove = true;
                },
                onPointerMove: (p) {
                  var d = p.localPosition.dx - leftDowPos;
                  leftPosTempPercent = leftStarPosPercent + (d / totle);
                  if (leftPosTempPercent < 0.0) {
                    leftPosTempPercent = 0;
                  } else if (leftPosTempPercent >
                      rightPosTempPercent - scrollDistance) {
                    leftPosTempPercent = rightPosTempPercent - scrollDistance;
                  }
                  textLeft = leftPosTempPercent;
                  setState(() {});
                },
                onPointerUp: (p) {
                  textLeft = -1;
                  leftStarPosPercent = leftPosTempPercent;
                  setState(() {});
                },
                child: Container(
                  width: 19,
                  height: 19,
                  alignment: Alignment.centerLeft,
                  child: Image.asset(
                    "assets/progress_inner.png",
                  ),
                ),
              )),
          Positioned(
              bottom: 0,
              left: rightPosTempPercent * totle,
              child: Listener(
                onPointerDown: (p) {
                  rightDowPos = p.localPosition.dx;
                  isLeftMove = false;
                },
                onPointerMove: (p) {
                  var d = p.localPosition.dx - rightDowPos;
                  rightPosTempPercent = rightStarPosPercent + (d / totle);
                  if (rightPosTempPercent <
                      leftPosTempPercent + scrollDistance) {
                    rightPosTempPercent = leftPosTempPercent + scrollDistance;
                  } else if (rightPosTempPercent > 1.0 - 0.03) {
                    rightPosTempPercent = 1.0 - 0.03;
                  }
                  textLeft = rightPosTempPercent;
                  setState(() {});
                },
                onPointerUp: (p) {
                  textLeft = -1;
                  rightStarPosPercent = rightPosTempPercent;
                  setState(() {});
                },
                child: Container(
                  width: 19,
                  height: 19,
                  alignment: Alignment.centerLeft,
                  child: Image.asset(
                    "assets/progress_inner.png",
                  ),
                ),
              )),
        ],
      ),
    );
  }
}
