/*
 * @author lsy
 * @date   2020/6/28
 **/
import 'package:flutter_common/Annotations/anno/Get.dart';
import 'package:flutter_common/Annotations/anno/Query.dart';
import 'package:flutter_common/Annotations/anno/ServiceCenter.dart';
import 'package:gm_flutter/ClueModel/server/entity/LevelOneFeedList.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanCompareDetail.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlansCompareFeed.dart';
import 'package:gm_flutter/ClueModel/server/entity/ProjectDetailsItem.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanBean.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanFeedBean.dart';
@ServiceCenter()
abstract class ClueApi {
  @Get("/api/janus/plans/plan_detail")
  ProjectDetailsItem getProjectDetails(@Query("plan_id") double plan_id);

  @Get("/api/janus/plans/compare_feed")
  PlansCompareFeed getPlansCompareFeed(
      @Query("plan_id") double plan_id, @Query("plan_type") double plan_type);

  @Get("api/janus/plans/plan_feed")
  LevelOneFeedList getLevelOneList(@Query("plan_id") int plan_id,
      @Query("tab_type") String tab_type, @Query("page") int page);

  @Get("api/janus/plans/compare")
  PlanCompareDetail getPlanCompareDetail(@Query("plan_ids") List<int> plan_ids);

  @Get("api/janus/plans/options")
  PlanBean getPlan();

  @Get("api/janus/plans/feed")
  PlanFeedBean getPlanFeed(
      @Query("tag_id")String tag_id,
      @Query("order_by")String order_by,
      @Query("current_city_id")String current_city_id,
      @Query("min_price")String min_price,
      @Query("max_price")String max_price,
      @Query("rank_type")String rank_type,
      @Query("page")int page,
      );
}
