/*
 * @Author: zx 
 * @Date: 2020-06-30 17:43:13 
 * @Last Modified by: zx
 * @Last Modified time: 2020-07-01 20:04:23
 */
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanCompareDetail.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';

class PlanCompareDetailModel extends BaseModel {
  LiveData<PlanCompareDetail> detailLive = LiveData();
  RxDispose rxDispose = RxDispose();

  void init() {
    ClueApiImpl.getInstance()
        .getPlanCompareDetail(DioUtil.getInstance().getDio(), [1,2])
        .listen((event) {
          if (event.error == 0) {
            detailLive.notifyView(event);
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {});
  }
  @override
  void dispose() {
    detailLive.dispost();
  }

}