/*
 * @author lsy
 * @date   2020/6/29
 **/
import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/server/entity/LevelOneFeedList.dart';
import 'package:gm_flutter/ClueModel/util/NumPlanUtil.dart';
import 'package:gm_flutter/ClueModel/view/FiveStarView.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseUtil.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';
import 'package:gm_flutter/commonModel/util/NumberUtil.dart';
import 'package:gm_flutter/main.mark.dart';

import '../../../main.dart';

class LevelOneItem extends StatelessWidget {
  final Cards cards;
  VoidCallback lowPrice;
  VoidCallback ask;
  Function(int planId) compare;
  Function(int planId) gotoPlan;
  int position;
  String tabName;
  int allSize;

  LevelOneItem(this.cards,
      {this.lowPrice,
      this.ask,
      this.compare,
      this.gotoPlan,
      this.position,
      this.tabName,
      this.allSize});

  @override
  Widget build(BuildContext context) {
    if (cards.cardType == "plan") {
      return PlanItem(context);
    } else if (cards.cardType == "hospital") {
      return HospitalItem(context);
    } else if (cards.cardType == "doctor") {
      return DoctorItem(context);
    } else if (cards.cardType == "diary") {
      return DiaryItem(context);
    }
  }

  static double getCardTypeHeight(Cards cards) {
    if (cards.cardType == "plan") {
      return 118;
    } else if (cards.cardType == "hospital") {
      return 149;
    } else if (cards.cardType == "doctor") {
      return 127;
    } else if (cards.cardType == "diary") {
      double image = (cards.diary.images == null ||
              cards.diary.images.isEmpty ||
              cards.diary.images.length < 2)
          ? 0
          : 175;
      double text = 22 * (cards.diary.content.length / 22) + 24.5;
      return 40 + image + text + 55;
    }
    return 0;
  }

  Widget DoctorItem(BuildContext context) {
    if (cards.doctor == null && !inProduction) {
      throw new Exception();
    }
    var price =
        NumPlanUtil.getPrice(cards.doctor.minPrice, cards.doctor.maxPrice);
    return GestureDetector(
      behavior: HitTestBehavior.opaque,
      onTap: () {
        buried_on_click_card(
            position, tabName, "doctor", cards.doctor.doctor_id);
        Map<String, dynamic> map = {
          "business_id": "${cards.doctor.doctor_id}",
          "referrer_tab_name": ""
        };
        RouterCenterImpl()
            .findMainRouter()
            .jumpPage(context, cards.doctor.gm_url, map, true);
      },
      child: Container(
        margin: EdgeInsets.only(left: 15, right: 15),
        height: 127,
        child: Stack(
          children: <Widget>[
            Positioned(
              top: 15,
              child: Container(
                width: 45,
                height: 45,
                child: ClipOval(
                  child: CachedNetworkImage(
                    imageUrl: cards.doctor.portrait,
                    fit: BoxFit.cover,
                  ),
                ),
              ),
            ),
            Positioned(
              left: 57,
              top: 17,
              child: Row(
                mainAxisSize: MainAxisSize.min,
                crossAxisAlignment: CrossAxisAlignment.baseline,
                textBaseline: TextBaseline.alphabetic,
                children: <Widget>[
                  baseText(cards.doctor.name, 15, Color(0xff333333),
                      bold: true),
                  Container(
                    margin: EdgeInsets.only(left: 4),
                    child: baseText(cards.doctor.title, 13, Color(0xff999999)),
                  )
                ],
              ),
            ),
            Positioned(
                top: 42,
                left: 57,
                child: Container(
                  width: MediaQuery.of(context).size.width - 30 - 57,
                  child: Row(
                    children: <Widget>[
                      FiveStarView(int.parse(cards.doctor.star), 5),
                      Expanded(
                        child: Container(),
                      ),
                      Row(
                        crossAxisAlignment: CrossAxisAlignment.baseline,
                        textBaseline: TextBaseline.alphabetic,
                        mainAxisSize: MainAxisSize.min,
                        children: <Widget>[
                          price == "暂无报价"
                              ? Container(
                                  width: 0,
                                  height: 0,
                                )
                              : baseText("¥", 12, Color(0xffFF5963)),
                          baseText(
                              price,
                              price == "暂无报价" ? 13 : 15,
                              price == "暂无报价"
                                  ? Color(0xff999999)
                                  : Color(0xffFF5963),
                              bold: price != "暂无报价")
                        ],
                      ),
                    ],
                  ),
                )),
            Positioned(
              left: 57,
              bottom: 15,
              child: Container(
                width: MediaQuery.of(context).size.width - 30 - 57,
                child: Row(
                  children: <Widget>[
                    Expanded(
                      child: askWidget(margin: true),
                    ),
                    Container(
                      width: 15,
                    ),
                    Expanded(
                      child: lowPriceWidget(margin: true),
                    )
                  ],
                ),
              ),
            ),
            allSize != null && position != null && position < allSize - 1
                ? Positioned(
                    left: 0,
                    bottom: 0,
                    child: Container(
                      width: MediaQuery.of(context).size.width - 30,
                      height: 0.5,
                      color: Color(0xffE5E5E5),
                    ),
                  )
                : Container(
                    width: 0,
                    height: 0,
                  )
          ],
        ),
      ),
    );
  }

  Widget HospitalItem(BuildContext context) {
    if (cards.hospital == null && !inProduction) {
      throw new Exception();
    }
    var price =
        NumPlanUtil.getPrice(cards.hospital.minPrice, cards.hospital.maxPrice);
    return GestureDetector(
        behavior: HitTestBehavior.opaque,
        onTap: () {
          buried_on_click_card(
              position, tabName, "hospital", cards.hospital.hosiptalId);
          Map<String, dynamic> map = {
            "business_id": "${cards.hospital.hosiptalId}",
            "referrer_tab_name": ""
          };
          RouterCenterImpl()
              .findMainRouter()
              .jumpPage(context, cards.hospital.gm_url, map, true);
        },
        child: Container(
          margin: EdgeInsets.only(left: 15, right: 15),
          height: 149,
          child: Stack(
            children: <Widget>[
              Positioned(
                left: 0,
                top: 15,
                child: Container(
                  width: 45,
                  height: 45,
                  child: ClipOval(
                    child: CachedNetworkImage(
                      imageUrl: cards.hospital.portrait,
                      fit: BoxFit.cover,
                    ),
                  ),
                ),
              ),
              Positioned(
                left: 57,
                top: 15,
                child: Container(
                  width: MediaQuery.of(context).size.width - 30 - 57,
                  child: baseText(cards.hospital.name, 15, Color(0xff333333),
                      bold: true),
                ),
              ),
              Positioned(
                  top: 42.5,
                  left: 57,
                  child: Container(
                      width: MediaQuery.of(context).size.width - 30 - 57,
                      child: Row(
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: <Widget>[
                          FiveStarView(int.parse(cards.hospital.star), 5),
                          Expanded(
                            child: Container(
                              height: 0,
                            ),
                          ),
                          Row(
                            crossAxisAlignment: CrossAxisAlignment.baseline,
                            textBaseline: TextBaseline.alphabetic,
                            mainAxisSize: MainAxisSize.min,
                            children: <Widget>[
                              price == "暂无报价"
                                  ? Container(
                                      width: 0,
                                      height: 0,
                                    )
                                  : baseText("¥", 12, Color(0xffFF5963)),
                              baseText(
                                  price,
                                  price == "暂无报价" ? 13 : 15,
                                  price == "暂无报价"
                                      ? Color(0xff999999)
                                      : Color(0xffFF5963),
                                  bold: price != "暂无报价")
                            ],
                          ),
                        ],
                      ))),
              Positioned(
                bottom: 15,
                left: 57,
                child: Container(
                  width: MediaQuery.of(context).size.width - 30 - 57,
                  child: Row(
                    children: <Widget>[
                      Expanded(
                        child: askWidget(margin: true),
                      ),
                      Container(
                        width: 15,
                      ),
                      Expanded(
                        child: lowPriceWidget(margin: true),
                      )
                    ],
                  ),
                ),
              ),
              Positioned(
                bottom: 63.5,
                left: 57,
                child: Container(
                  width: MediaQuery.of(context).size.width - 30 - 57,
                  child:
                      baseText(cards.hospital.address, 12, Color(0xff666666)),
                ),
              ),
//              Positioned(
//                left: 57,
//                top: 47,
//                child: FiveStarView(int.parse(cards.hospital.star), 5),
//              ),
              allSize != null && position != null && position < allSize - 1
                  ? Positioned(
                      left: 0,
                      bottom: 0,
                      child: Container(
                        width: MediaQuery.of(context).size.width - 30,
                        height: 0.5,
                        color: Color(0xffE5E5E5),
                      ),
                    )
                  : Container(
                      width: 0,
                      height: 0,
                    )
            ],
          ),
        ));
  }

  Widget PlanItem(BuildContext context) {
    if (cards.plan == null && !inProduction) {
      throw new Exception();
    }
    String price =
        NumPlanUtil.getPrice(cards.plan.minPrice, cards.plan.maxPrice);
    return Column(
      children: <Widget>[
        Container(
            height: 117.5,
            margin: EdgeInsets.only(left: 15, right: 15),
            child: Column(
              mainAxisSize: MainAxisSize.min,
              children: <Widget>[
                Container(
                  height: 11,
                ),
                Row(
                  mainAxisSize: MainAxisSize.min,
                  crossAxisAlignment: CrossAxisAlignment.baseline,
                  textBaseline: TextBaseline.alphabetic,
                  children: <Widget>[
                    Container(
                      constraints: BoxConstraints(
                          maxWidth:
                              MediaQuery.of(context).size.width - 15 - 130),
                      child: baseText(
                          cards.plan.planName, 15, Color(0xff282828),
                          bold: true),
                    ),
                    Expanded(
                      child: Container(),
                    ),
                    price == "暂无报价"
                        ? Container(
                            width: 0,
                            height: 0,
                          )
                        : baseText("¥", 12, Color(0xffFF5963)),
                    baseText(price, price == "暂无报价" ? 13 : 15,
                        price == "暂无报价" ? Color(0xff999999) : Color(0xffFF5963),
                        bold: price != "暂无报价")
                  ],
                ),
                Container(
                  margin: EdgeInsets.only(top: 7),
                  alignment: Alignment.centerRight,
                  child: baseText("指导价：${cards.plan.guide_price ?? "暂无报价"}", 11,
                      Color(0xff666666)),
                ),
                Container(
                  margin: EdgeInsets.only(top: 11),
                  height: 37,
                  child: Row(
                    children: <Widget>[
                      compareWidget(),
                      Expanded(
                        child: askWidget(),
                      ),
                      Expanded(
                        child: lowPriceWidget(),
                      )
                    ],
                  ),
                )
              ],
            )).gestureDetector(() {
          buried_on_click_card(
              position, tabName, "level_two_plan", "${cards.plan.plan_id}");
          Map<String, dynamic> map = {
            "business_id": "${cards.plan.plan_id}",
            "planId": cards.plan.plan_id,
            "referrer_tab_name": tabName
          };
          RouterCenterImpl()
              .findMainRouter()
              .jumpPage(context, "level_two_plan_deatil", map, false);
        }),
        allSize != null && position != null && position < allSize - 1
            ? Container(
                width: MediaQuery.of(context).size.width - 30,
                height: 0.5,
                color: Color(0xffE5E5E5),
              )
            : Container(
                height: 0.5,
              ),
      ],
    );
  }

  Widget lowPriceWidget({bool margin = false}) {
    return GestureDetector(
      onTap: lowPrice,
      behavior: HitTestBehavior.opaque,
      child: Container(
        margin: EdgeInsets.only(left: margin ? 0.0 : 15),
        height: 37,
        decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(18.5),
            color: Color(0xffFFF5F5)),
        alignment: Alignment.center,
        child: baseText("获取底价", 14, Color(0xffFF5963), bold: true),
      ),
    );
  }

  Widget askWidget({bool margin = false}) {
    return GestureDetector(
      onTap: ask,
      behavior: HitTestBehavior.opaque,
      child: Container(
        margin: EdgeInsets.only(left: margin ? 0 : 15),
        height: 37,
        decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(18.5),
            color: Color(0xffEEFDFD)),
        alignment: Alignment.center,
        child: baseText("咨询", 14, Color(0xff3FB5AF), bold: true),
      ),
    );
  }

  Widget compareWidget() {
    return Container(
      height: 30,
      width: 71,
      child: Row(
        mainAxisSize: MainAxisSize.min,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: <Widget>[
          Container(
            width: 18,
            height: 18,
            child: Image.asset("assets/vs.png"),
          ),
          Container(
            margin: EdgeInsets.only(left: 1.5),
            child: baseText("去比较", 13, Color(0xff282828), bold: true),
          )
        ],
      ).gestureDetector(() {
        compare(cards.plan.plan_id);
      }),
    );
  }

  Widget DiaryItem(BuildContext context) {
    if (cards.diary == null && !inProduction) {
      throw new Exception();
    }
    return Container(
      margin: EdgeInsets.only(left: 20, right: 20),
      width: double.maxFinite,
      child: Column(
        mainAxisSize: MainAxisSize.min,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: <Widget>[
          Container(
            margin: EdgeInsets.only(top: 15),
            height: 25,
            child: Row(
              mainAxisSize: MainAxisSize.min,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: <Widget>[
                Container(
                  width: 25,
                  height: 25,
                  child: ClipOval(
                    child: CachedNetworkImage(
                      imageUrl: cards.diary.user.portrait,
                      fit: BoxFit.cover,
                    ),
                  ),
                ),
                Container(
                  margin: EdgeInsets.only(left: 8),
                  child: baseText(
                      cards.diary.user.userName, 13, Color(0xff999999)),
                ),
                cards.diary.userLevel != null &&
                        cards.diary.userLevel.levelIcon != null
                    ? Container(
                        width: 31,
                        height: 12,
                        child: CachedNetworkImage(
                          imageUrl: cards.diary.userLevel.levelIcon,
                        ),
                      )
                    : Container(
                        width: 0,
                      )
              ],
            ),
          ),
          (cards.diary.images == null ||
                  cards.diary.images.isEmpty ||
                  cards.diary.images.length < 2)
              ? Container(
                  height: 0,
                )
              : Container(
                  margin: EdgeInsets.only(top: 12),
                  height: 163,
                  child: Row(
                    children: <Widget>[
                      Expanded(
                        child: Container(
                          decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(4),
                              image: DecorationImage(
                                  fit: BoxFit.cover,
                                  image: NetworkImage(
                                      cards.diary.images[0].imageHalf))),
                          alignment: Alignment.bottomLeft,
                          child: Container(
                            width: 65.5,
                            height: 18,
                            decoration: BoxDecoration(
                                color: Color(0x4c000000),
                                borderRadius: BorderRadius.only(
                                  bottomLeft: Radius.circular(4),
                                  topRight: Radius.circular(2),
                                )),
                            alignment: Alignment.center,
                            child: baseText(
                                cards.diary.images[0].desc, 11, Colors.white),
                          ),
                        ),
                      ),
                      Container(
                        width: 9,
                      ),
                      Expanded(
                        child: Container(
                          decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(4),
                              image: DecorationImage(
                                  fit: BoxFit.cover,
                                  image: NetworkImage(
                                      cards.diary.images[1].imageHalf))),
                          alignment: Alignment.bottomLeft,
                          child: Container(
                            width: 65.5,
                            height: 18,
                            decoration: BoxDecoration(
                                color: Color(0x4c000000),
                                borderRadius: BorderRadius.only(
                                  bottomLeft: Radius.circular(4),
                                  topRight: Radius.circular(2),
                                )),
                            alignment: Alignment.center,
                            child: baseText(
                                cards.diary.images[1].desc, 11, Colors.white),
                          ),
                        ),
                      )
                    ],
                  )),
          cards.diary.content != null && cards.diary.content.isNotEmpty
              ? Container(
                  margin: EdgeInsets.only(top: 7.5, bottom: 4),
                  child: Text(
                    cards.diary.content,
                    textScaleFactor: 1.0,
                    maxLines: 5,
                    strutStyle: StrutStyle(forceStrutHeight: true, height: 2),
                    overflow: TextOverflow.ellipsis,
                    style: TextStyle(
                        decoration: TextDecoration.none,
                        fontSize: 15,
                        color: Color(0xff464646),
                        fontStyle: FontStyle.normal,
                        fontWeight: FontWeight.w400),
                  ),
                )
              : Container(
                  height: 0,
                ),
          baseText("项目${cards.diary.title}", 13, Color(0xff999999)),
          Container(
            margin: EdgeInsets.only(top: 9, bottom: 16),
            height: 14,
            child: Row(
              mainAxisSize: MainAxisSize.min,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: <Widget>[
                Container(
                  width: 14,
                  height: 14,
                  child: Image.asset("assets/eye.png"),
                ),
                Container(
                  margin: EdgeInsets.only(left: 5, right: 20),
                  child:
                      baseText("${cards.diary.viewNum}", 12, Color(0xff999999)),
                ),
                Container(
                  width: 14,
                  height: 14,
                  child: Image.asset("assets/arguement.png"),
                ),
                Container(
                  margin: EdgeInsets.only(left: 5, right: 20),
                  child: baseText(
                      "${cards.diary.replyNum}", 12, Color(0xff999999)),
                ),
                Container(
                  width: 14,
                  height: 14,
                  child: Image.asset("assets/heart.png"),
                ),
                Container(
                  margin: EdgeInsets.only(left: 5, right: 20),
                  child:
                      baseText("${cards.diary.voteNum}", 12, Color(0xff999999)),
                )
              ],
            ),
          ),
          allSize != null && position != null && position < allSize - 1
              ? Container(
                  width: double.maxFinite,
                  height: 0.5,
                  color: Color(0xffE5E5E5),
                )
              : Container(
                  height: 0.5,
                )
        ],
      ),
    ).gestureDetector(() {
      RouterCenterImpl().findMainRouter().jumpPage(context,
          "gengmei://diary?diary_id=${cards.diary.diaryId}", null, true);
    });
  }

  buried_on_click_card(
      int position, String btnName, String cardContentType, String cardId) {
    Map<String, dynamic> buriedMap;
    buriedMap = {
      "tab_name": tabName,
      "position": position,
      "card_id": cardId,
      "card_name": "card",
      "card_type": "card",
      "transaction_type": "-1",
      "card_content_type": cardContentType
    };
    RouterCenterImpl().findMainRouter().buriedEvent("on_click_card", buriedMap);
  }
}
